/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;

public class ItemStorageHelper {
    public static List<ItemStack> getCraftingRemainings(List<ItemStorage> list) {
        return ItemStackHelper.getCraftingRemainings(list.stream().map(ItemStorage::getItemStack).toList());
    }

    public static List<ItemStack> mapAndFilterNotEmpty(List<ItemStorage> list, Function<ItemStack, ItemStack> func) {
        return ItemStackHelper.mapAndFilterNotEmpty(list.stream().map(ItemStorage::getItemStack).toList(), func);
    }

    public static List<ItemStorage> filterNotEmpty(List<ItemStorage> inputs) {
        return inputs.stream().filter(storage -> !storage.isEmpty()).toList();
    }

    public static List<List<ItemStack>> getStacksLists(List<ItemStorage> list) {
        return list.stream().map(ItemStorageHelper::getStacks).toList();
    }

    public static List<ItemStack> getStacks(ItemStorage storage) {
        return Collections.singletonList(storage.getItemStack());
    }

    public static boolean matches(ItemStorage storage, ItemStack stack, boolean min) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize((ItemStack)storage.getItemStack(), (ItemStack)stack, (!storage.ignoreDamageValue() ? 1 : 0) != 0, (!storage.ignoreNBT() ? 1 : 0) != 0, (boolean)min, (boolean)true);
    }

    private ItemStorageHelper() {
    }
}

