/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_tweaks.api.common.tool.ToolTypeTags;

public class IngredientHelper {
    private static final Gson GSON = new Gson();

    public static List<List<ItemStack>> getStacksList(@NotNull List<Ingredient> ingredients) {
        return ingredients.stream().map(IngredientHelper::getStacks).toList();
    }

    public static List<ItemStack> getStacks(@NotNull Ingredient ingredient) {
        return Arrays.asList(ingredient.getItems());
    }

    public static boolean isTool(@NotNull Ingredient ingredient, @NotNull EquipmentTypeEntry toolType) {
        return Arrays.stream(ingredient.getItems()).filter(stack -> !ToolTypeTags.isInBlacklist((ItemStack)stack, (ResourceLocation)toolType.getRegistryName())).allMatch(stack -> ItemStackHelper.isTool(stack, toolType));
    }

    @NotNull
    public static EquipmentTypeEntry findFirstToolType(@NotNull Ingredient ingredient) {
        for (EquipmentTypeEntry toolType : IMinecoloniesAPI.getInstance().getEquipmentTypeRegistry()) {
            if (toolType == ModEquipmentTypes.none.get() || !IngredientHelper.isTool(ingredient, toolType)) continue;
            return toolType;
        }
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    @NotNull
    public static String toJson(@NotNull Ingredient ingredient) {
        return GSON.toJson((JsonElement)Ingredient.CODEC.encodeStart((DynamicOps)JsonOps.COMPRESSED, (Object)ingredient).getOrThrow());
    }

    @NotNull
    public static Ingredient fromJson(@NotNull String json) {
        return (Ingredient)((Pair)Ingredient.CODEC.decode((DynamicOps)JsonOps.COMPRESSED, (Object)((JsonElement)GSON.fromJson(json, JsonElement.class))).getOrThrow()).getFirst();
    }

    public static boolean isDamageable(@NotNull Ingredient ingredient) {
        if (ingredient.isEmpty()) {
            return false;
        }
        for (ItemStack item : ingredient.getItems()) {
            if (item.isDamageableItem()) continue;
            return false;
        }
        return true;
    }

    private IngredientHelper() {
    }
}

