/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IItemStackExtension;

public class GenericRecipeHelper {
    public static List<ItemStack> getAdditionalOutputs(List<List<ItemStack>> inputs) {
        return GenericRecipeHelper.getAdditionalOutputs(inputs, IItemStackExtension::getCraftingRemainingItem);
    }

    public static List<ItemStack> getAdditionalOutputs(List<List<ItemStack>> inputs, Function<ItemStack, ItemStack> getCraftingRemainingStack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (List<ItemStack> input : inputs) {
            ItemStack allRemaining = ItemStack.EMPTY;
            for (ItemStack stack : input) {
                ItemStack remain = getCraftingRemainingStack.apply(stack);
                if (remain.isEmpty() || !allRemaining.isEmpty() && !ItemStack.matches((ItemStack)allRemaining, (ItemStack)remain)) {
                    allRemaining = ItemStack.EMPTY;
                    break;
                }
                allRemaining = remain;
            }
            if (allRemaining.isEmpty()) continue;
            list.add(allRemaining);
        }
        return list;
    }

    private GenericRecipeHelper() {
    }
}

