/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.crafting;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;

public class BucketFillingGenericRecipe
implements IGenericRecipe {
    private final ItemStack emptyBucket;
    private final Fluid fluid;
    private final DataComponentPatch dataComponentPatch;
    private final ItemStack filledBucket;
    private final List<ItemStack> allMultiOutputs;
    private final List<List<ItemStack>> inputs;

    public BucketFillingGenericRecipe(ItemStack emptyBucket, Fluid fluid, DataComponentPatch dataComponentPatch, ItemStack filledBucket) {
        this.emptyBucket = emptyBucket;
        this.fluid = fluid;
        this.dataComponentPatch = dataComponentPatch;
        this.filledBucket = filledBucket;
        this.allMultiOutputs = Collections.singletonList(this.getPrimaryOutput());
        this.inputs = Collections.singletonList(Collections.singletonList(this.emptyBucket));
    }

    @Nullable
    public ResourceLocation getRecipeId() {
        return MineColoniesCompatibility.rl("bucket_filling." + this.getSegment(BuiltInRegistries.ITEM.getKey((Object)this.emptyBucket.getItem())) + "." + this.getSegment(BuiltInRegistries.FLUID.getKey((Object)this.getFluid())) + "." + this.getSegment(BuiltInRegistries.ITEM.getKey((Object)this.filledBucket.getItem())));
    }

    public ItemStack getEmptyBucket() {
        return this.emptyBucket;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public DataComponentPatch getDataComponentPatch() {
        return this.dataComponentPatch;
    }

    public ItemStack getFilledBucket() {
        return this.filledBucket;
    }

    protected String getSegment(ResourceLocation id) {
        return id.getNamespace() + "_" + id.getPath();
    }

    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.filledBucket;
    }

    @NotNull
    public List<ItemStack> getAllMultiOutputs() {
        return this.allMultiOutputs;
    }

    @NotNull
    public List<ItemStack> getAdditionalOutputs() {
        return Collections.emptyList();
    }

    @NotNull
    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public Optional<Boolean> matchesOutput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    public Optional<Boolean> matchesInput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return Optional.empty();
    }

    @NotNull
    public Block getIntermediate() {
        return Blocks.AIR;
    }

    public int getGridSize() {
        return 1;
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return null;
    }

    @NotNull
    public EquipmentTypeEntry getRequiredTool() {
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    @Nullable
    public EntityType<?> getRequiredEntity() {
        return null;
    }

    @NotNull
    public Supplier<List<Component>> getRestrictions() {
        return Collections::emptyList;
    }

    public int getLevelSort() {
        return -1;
    }
}

