/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.building.module;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.IRestrictableModuleView;
import steve_gall.minecolonies_compatibility.core.client.gui.RestrictableModuleWindow;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.network.message.RestrictSetAreaMessage;
import steve_gall.minecolonies_compatibility.core.common.network.message.RestrictSetEnabledMessage;

public class RestrictableModuleView
extends AbstractBuildingModuleView
implements IRestrictableModuleView {
    public static final Component DESC = Component.translatable((String)"com.minecolonies.coremod.gui.workerhuts.restrict");
    private boolean restrictEnabled = false;
    @Nullable
    private BlockPos restrictPos1 = null;
    @Nullable
    private BlockPos restrictPos2 = null;

    public void deserialize(RegistryFriendlyByteBuf buf) {
        this.restrictEnabled = buf.readBoolean();
        this.restrictPos1 = (BlockPos)buf.readNullable(FriendlyByteBuf::readBlockPos);
        this.restrictPos2 = (BlockPos)buf.readNullable(FriendlyByteBuf::readBlockPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new RestrictableModuleWindow(this, MineColoniesCompatibility.rl("gui/layouthuts/layoutrestrictable.xml"));
    }

    public String getIcon() {
        return "restrict";
    }

    public Component getDesc() {
        return DESC;
    }

    @Override
    public void setRestrictEnabled(boolean enabled) {
        this.restrictEnabled = enabled;
        PacketDistributor.sendToServer((CustomPacketPayload)new RestrictSetEnabledMessage(this, enabled), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void setRestrictArea(@NotNull BlockPos pos1, @NotNull BlockPos pos2) {
        this.restrictPos1 = pos1;
        this.restrictPos2 = pos2;
        PacketDistributor.sendToServer((CustomPacketPayload)new RestrictSetAreaMessage(this, pos1, pos2), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public boolean isRestrictEnabled() {
        return this.restrictEnabled;
    }

    @Override
    @NotNull
    public BlockPos getRestrictAreaPos1() {
        BlockPos pos1 = this.restrictPos1;
        return pos1 != null ? pos1 : this.getBuildingView().getPosition();
    }

    @Override
    @NotNull
    public BlockPos getRestrictAreaPos2() {
        BlockPos pos2 = this.restrictPos2;
        return pos2 != null ? pos2 : this.getBuildingView().getPosition();
    }
}

