/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.building.module;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.building.module.AbstractCraftingModuleWithExternalWorkingBlocks;
import steve_gall.minecolonies_compatibility.api.common.building.module.ICraftingResultListenerModule;
import steve_gall.minecolonies_compatibility.core.common.crafting.BucketFillingCraftingType;
import steve_gall.minecolonies_compatibility.core.common.crafting.BucketFillingRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.init.ModCraftingTypes;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizableRecipeStorage;
import steve_gall.minecolonies_tweaks.api.common.crafting.ICustomizedRecipeStorage;

public class BucketFillingCraftingModule
extends AbstractCraftingModuleWithExternalWorkingBlocks
implements ICraftingResultListenerModule {
    public BucketFillingCraftingModule(String id, JobEntry jobEntry) {
        super(jobEntry);
    }

    public void improveRecipe(IRecipeStorage recipe, int count, ICitizenData citizen) {
    }

    @Override
    public boolean isWorkingBlock(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        IFluidHandler fluidHandler;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && (fluidHandler = (IFluidHandler)blockEntity.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, pos, state, blockEntity, null)) != null) {
            return true;
        }
        return state.getBlock() instanceof LiquidBlock && state.getFluidState().isSource();
    }

    @Override
    public boolean needWorkingBlock(@NotNull IRecipeStorage recipeStorage) {
        return BucketFillingCraftingModule.toRecipe(recipeStorage) != null;
    }

    @NotNull
    public String getId() {
        return ModCraftingTypes.BUCKET_FILLING.getId().getPath();
    }

    public Set<CraftingType> getSupportedCraftingTypes() {
        return Set.of((CraftingType)ModCraftingTypes.BUCKET_FILLING.get());
    }

    public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
        return true;
    }

    @Override
    @NotNull
    public Component getWorkingBlockNotFoundMessage(@NotNull IRecipeStorage recipeStorage) {
        BucketFillingRecipeStorage recipe = BucketFillingCraftingModule.toRecipe(recipeStorage);
        if (recipe != null) {
            return Component.translatable((String)"minecolonies_compatibility.interaction.no_fluid_source", (Object[])new Object[]{recipe.getFluidStack(1000).getHoverName()});
        }
        return super.getWorkingBlockNotFoundMessage(recipeStorage);
    }

    @Override
    public boolean canBlockRecipeWorking(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IRecipeStorage recipeStorage) {
        BucketFillingRecipeStorage recipe = BucketFillingCraftingModule.toRecipe(recipeStorage);
        if (recipe != null) {
            return this.drain(level, pos, state, recipe, true);
        }
        return false;
    }

    @Override
    public void onCrafted(@NotNull AbstractEntityCitizen worker, @NotNull BlockPos workingPos, @NotNull IRecipeStorage recipeStorage) {
        BucketFillingRecipeStorage recipe = BucketFillingCraftingModule.toRecipe(recipeStorage);
        if (recipe != null) {
            Level level = worker.level();
            this.drain(level, workingPos, level.getBlockState(workingPos), recipe, false);
        }
    }

    public boolean drain(Level level, BlockPos pos, BlockState state, BucketFillingRecipeStorage recipe, boolean simulate) {
        Block block;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            for (Direction direction : Direction.values()) {
                IFluidHandler fluidHandler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)direction);
                if (fluidHandler == null) continue;
                FluidStack stack = recipe.getFluidStack(1000);
                FluidStack drained = fluidHandler.drain(stack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                return drained.getAmount() >= stack.getAmount();
            }
        }
        if (recipe.getDataComponentPatch().isEmpty() && (block = state.getBlock()) instanceof LiquidBlock) {
            LiquidBlock liquid = (LiquidBlock)block;
            if (state.getFluidState().isSource() && liquid.fluid == recipe.getFluid()) {
                if (!simulate) {
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
                }
                return true;
            }
        }
        return false;
    }

    @NotNull
    public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(Level level) {
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            BucketFillingRecipeStorage recipe;
            if (!fluid.isSource(fluid.defaultFluidState()) || (recipe = BucketFillingCraftingType.parse(new ItemStack((ItemLike)fluid.getBucket()))) == null) continue;
            recipes.add(recipe.getGenericRecipe());
        }
        return recipes;
    }

    public static BucketFillingRecipeStorage toRecipe(IToken<?> token) {
        return BucketFillingCraftingModule.toRecipe(IColonyManager.getInstance().getRecipeManager().getRecipe(token));
    }

    public static BucketFillingRecipeStorage toRecipe(IRecipeStorage recipeStorage) {
        ICustomizableRecipeStorage crs;
        ICustomizedRecipeStorage iCustomizedRecipeStorage;
        if (recipeStorage instanceof ICustomizableRecipeStorage && (iCustomizedRecipeStorage = (crs = (ICustomizableRecipeStorage)recipeStorage).getImpl()) instanceof BucketFillingRecipeStorage) {
            BucketFillingRecipeStorage recipe = (BucketFillingRecipeStorage)iCustomizedRecipeStorage;
            return recipe;
        }
        return null;
    }
}

