/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.common.building.module;

import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AccessDirection {
    INSERT(0),
    EXTRACT(1),
    INSERT_EXTRACT(2);

    private final int id;

    @NotNull
    public static AccessDirection deserialize(@Nullable Tag tag) {
        if (tag instanceof NumericTag) {
            NumericTag numeric = (NumericTag)tag;
            return AccessDirection.byId(numeric.getAsInt());
        }
        return INSERT_EXTRACT;
    }

    @NotNull
    public static Tag serialize(@NotNull AccessDirection value) {
        return IntTag.valueOf((int)value.id);
    }

    @NotNull
    public static AccessDirection byId(int id) {
        for (AccessDirection value : AccessDirection.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        return INSERT_EXTRACT;
    }

    private AccessDirection(int id) {
        this.id = id;
    }

    @NotNull
    public AccessDirection prev() {
        AccessDirection[] values = AccessDirection.values();
        return values[(this.ordinal() - 1) % values.length];
    }

    @NotNull
    public AccessDirection next() {
        AccessDirection[] values = AccessDirection.values();
        return values[(this.ordinal() + 1) % values.length];
    }

    @NotNull
    public Tag serialize() {
        return AccessDirection.serialize(this);
    }

    public int getId() {
        return this.id;
    }

    public boolean canExtract() {
        return this != INSERT;
    }

    public boolean canInsert() {
        return this != EXTRACT;
    }
}

