/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.WindowConstants;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;
import steve_gall.minecolonies_compatibility.core.common.inventory.TeachRecipeMenu;
import steve_gall.minecolonies_compatibility.core.common.item.ItemHandlerHelper2;
import steve_gall.minecolonies_compatibility.core.common.network.message.TeachRecipeMenuSwitchingMessage;
import steve_gall.minecolonies_compatibility.module.common.ModuleManager;

public abstract class TeachRecipeScreen<MENU extends TeachRecipeMenu<RECIPE, ?>, RECIPE>
extends AbstractContainerScreen<MENU> {
    public static final Component TEXT_DONE = Component.translatable((String)"gui.done");
    public static final int SWITCH_WIDTH = WindowConstants.CRAFTING_SWITCH_SIZE.width;
    public static final int SWITCH_HEIGHT = WindowConstants.CRAFTING_SWITCH_SIZE.height;
    public static final int SWITCH_X_OFFSET = 148;
    public static final int SWITCH_Y_OFFSET = 43 - SWITCH_HEIGHT / 2;
    private Button doneButton;
    private ImageButton switchButton;
    private Component lastError;

    public TeachRecipeScreen(MENU menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    protected void init() {
        super.init();
        this.doneButton = Button.builder((Component)TEXT_DONE, this::onDoneButtonPress).bounds(this.leftPos + 1, this.topPos + this.imageHeight + 4, 150, 20).build();
        this.doneButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.switchButton = new ImageButton(this.leftPos + this.getSwitchButtonX(), this.topPos + this.getSwitchButtonY(), SWITCH_WIDTH, SWITCH_HEIGHT, WindowConstants.CRAFTING_SWITCH, btn -> PacketDistributor.sendToServer((CustomPacketPayload)new TeachRecipeMenuSwitchingMessage(), (CustomPacketPayload[])new CustomPacketPayload[0]));
        this.switchButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.switchButton);
    }

    public int getSwitchButtonX() {
        return 148;
    }

    public int getSwitchButtonY() {
        return SWITCH_Y_OFFSET;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.lastError != null) {
            int x = this.doneButton.getX() + (this.doneButton.getWidth() - this.minecraft.font.width((FormattedText)this.lastError)) / 2;
            int y = this.doneButton.getY() + this.doneButton.getHeight() + 2;
            graphics.drawString(this.minecraft.font, this.lastError, x, y, -65536, true);
        }
        this.switchButton.visible = !ModuleManager.POLYMORPH.isLoaded() && ((TeachRecipeMenu)this.menu).getRecipes().size() >= 2;
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(this.getTexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public abstract ResourceLocation getTexture();

    protected void containerTick() {
        super.containerTick();
        Component error = this.getError();
        this.doneButton.active = error == null;
        this.lastError = error;
    }

    protected Component getError() {
        Object recipe = ((TeachRecipeMenu)this.menu).getRecipe();
        if (recipe == null) {
            return TeachRecipeMenu.TEXT_RECIPE_NOT_FOUND;
        }
        return ((TeachRecipeMenu)this.menu).getCurrentError();
    }

    private void onDoneButtonPress(Button button) {
        if (this.getError() != null) {
            return;
        }
        Object recipe = ((TeachRecipeMenu)this.menu).getRecipe();
        if (recipe != null) {
            List<ItemStorage> input = ItemHandlerHelper2.unwrap((IItemHandler)new InvWrapper((Container)((TeachRecipeMenu)this.menu).getInputContainer()), true).stream().map(stack -> {
                int amount = stack.getCount();
                stack = stack.copy();
                stack.setCount(1);
                ItemStorage storage = new ItemStorage(stack);
                storage.setAmount(amount);
                return storage;
            }).toList();
            this.onDone(recipe, input);
        }
    }

    protected abstract void onDone(RECIPE var1, List<ItemStorage> var2);
}

