/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.butcher.ButcherableIconCache;
import steve_gall.minecolonies_compatibility.api.common.butcher.CustomizedButcherable;
import steve_gall.minecolonies_compatibility.core.common.building.module.ButcherableListModuleView;

public class ButcherableListModuleWindow
extends AbstractModuleWindow<ButcherableListModuleView> {
    public static final String OUTPUT_ICON = "outputIcon";
    public static final String OUTPUT_NAME = "outputName";
    public static final Component ON = Component.translatable((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon");
    public static final Component OFF = Component.translatable((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff");
    protected final ButcherableListModuleView module;
    protected final ScrollingList resourceList;
    private final List<ButcherableIconCache> groupedItemList;
    private final Map<ItemStack, String> descriptionCache;
    private final Map<ItemStack, String> hoverNameCache;
    private String filter = "";
    private int tick = 0;
    private int tickCounter = 0;
    private List<ButcherableIconCache> currentDisplayedList;

    public ButcherableListModuleWindow(ButcherableListModuleView module, ResourceLocation res) {
        super((IBuildingModuleView)module, res);
        this.module = module;
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class);
        this.groupedItemList = new ArrayList<ButcherableIconCache>(CustomizedButcherable.getRegistry().values().stream().filter(module.getDisplayPredicate()::test).map(ButcherableIconCache::new).toList());
        this.descriptionCache = new HashMap<ItemStack, String>();
        this.hoverNameCache = new HashMap<ItemStack, String>();
        ((TextField)this.window.findPaneOfTypeByID("input", TextField.class)).setHandler(input -> this.setFilter(input.getText()));
    }

    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        String buttonId = button.getID();
        if (Objects.equals(buttonId, "switch")) {
            int row = this.resourceList.getListElementIndexByPane((Pane)button);
            ButcherableIconCache item = this.currentDisplayedList.get(row);
            this.toggleItems(Arrays.asList(item));
        } else if (Objects.equals(buttonId, "resetDefault")) {
            this.clearItems();
        } else if (Objects.equals(buttonId, "toggleInCurrent")) {
            this.toggleItems(this.currentDisplayedList);
        } else if (Objects.equals(buttonId, "resetInCurrent")) {
            this.removeItems(this.currentDisplayedList);
        }
    }

    public void addItems(Collection<ButcherableIconCache> items) {
        this.module.addIds(items.stream().map(item -> item.getButcherable().getId()).toList());
        this.resourceList.refreshElementPanes();
    }

    public void removeItems(Collection<ButcherableIconCache> items) {
        this.module.removeIds(items.stream().map(item -> item.getButcherable().getId()).toList());
        this.resourceList.refreshElementPanes();
    }

    public void toggleItems(Collection<ButcherableIconCache> items) {
        List<ResourceLocation> toRemoves = items.stream().map(item -> item.getButcherable().getId()).filter(id -> this.module.containsId((ResourceLocation)id)).toList();
        List<ResourceLocation> toAddes = items.stream().map(item -> item.getButcherable().getId()).filter(id -> !this.module.containsId((ResourceLocation)id)).toList();
        this.module.removeIds(toRemoves);
        this.module.addIds(toAddes);
        this.resourceList.refreshElementPanes();
    }

    public void clearItems() {
        this.module.clearIds();
        this.resourceList.refreshElementPanes();
    }

    public void setFilter(String newFilter) {
        if (!newFilter.equals(this.filter)) {
            this.filter = newFilter;
            this.tick = 10;
        }
    }

    public void onOpened() {
        super.onOpened();
        this.updateResources();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
        if (!Screen.hasShiftDown()) {
            ++this.tickCounter;
        }
    }

    private boolean testFilter(ItemStack stack, String lowerCaseFilter) {
        return this.descriptionCache.computeIfAbsent(stack, s -> s.getDescriptionId().toLowerCase(Locale.US)).contains(lowerCaseFilter) || this.hoverNameCache.computeIfAbsent(stack, s -> s.getHoverName().getString().toLowerCase(Locale.US)).contains(lowerCaseFilter);
    }

    private boolean testFilter(Collection<ItemStack> stacks, String lowerCaseFilter) {
        return stacks.stream().anyMatch(stack -> this.testFilter((ItemStack)stack, lowerCaseFilter));
    }

    private boolean testFilter(ButcherableIconCache item, String lowerCaseFilter) {
        return this.testFilter(item.getItemIcons(), lowerCaseFilter);
    }

    protected void updateResources() {
        Predicate<ButcherableIconCache> filterPredicate;
        String lowerCase = this.filter.toLowerCase(Locale.US);
        Predicate<ButcherableIconCache> predicate = filterPredicate = this.filter.isEmpty() ? item -> true : item -> this.testFilter((ButcherableIconCache)item, lowerCase);
        if (this.currentDisplayedList != null) {
            this.currentDisplayedList.clear();
            this.updateResourceList();
        }
        this.currentDisplayedList = new ArrayList<ButcherableIconCache>();
        this.groupedItemList.stream().filter(filterPredicate).forEach(this.currentDisplayedList::add);
        this.currentDisplayedList.sort(this::compareResources);
        this.updateResourceList();
    }

    protected int compareResources(ButcherableIconCache item1, ButcherableIconCache item2) {
        boolean isInverted = this.module.isInverted();
        boolean contains1 = this.module.containsId(item1.getButcherable().getId());
        boolean contains2 = this.module.containsId(item2.getButcherable().getId());
        if (isInverted) {
            return Boolean.compare(contains1, contains2);
        }
        return Boolean.compare(contains2, contains1);
    }

    private void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ButcherableListModuleWindow.this.currentDisplayedList.size();
            }

            private ItemStack getIcon(List<ItemStack> stacks) {
                int size = stacks.size();
                if (size == 0) {
                    return ItemStack.EMPTY;
                }
                int index = ButcherableListModuleWindow.this.tickCounter / 30 % size;
                return stacks.get(index);
            }

            public void updateElement(int index, Pane rowPane) {
                ButcherableIconCache item = ButcherableListModuleWindow.this.currentDisplayedList.get(index);
                ItemStack output = this.getIcon(item.getItemIcons());
                ItemIcon outputIcon = (ItemIcon)rowPane.findPaneOfTypeByID(ButcherableListModuleWindow.OUTPUT_ICON, ItemIcon.class);
                outputIcon.setItem(output);
                Text outputLabel = (Text)rowPane.findPaneOfTypeByID(ButcherableListModuleWindow.OUTPUT_NAME, Text.class);
                outputLabel.setText(output.getHoverName());
                outputLabel.setColors(0);
                boolean contains = ButcherableListModuleWindow.this.module.containsId(item.getButcherable().getId());
                boolean isInverted = ButcherableListModuleWindow.this.module.isInverted();
                Button switchButton = (Button)rowPane.findPaneOfTypeByID("switch", Button.class);
                boolean on = isInverted && !contains || !isInverted && contains;
                switchButton.setText(on ? ON : OFF);
            }
        });
    }
}

