/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import steve_gall.minecolonies_compatibility.core.client.gui.AccessDirectionButton;
import steve_gall.minecolonies_compatibility.core.client.gui.NetworkStorageViewScreenUtils;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.block.entity.IAccessDirectionHolder;
import steve_gall.minecolonies_compatibility.core.common.block.entity.INetworkStorageViewHolder;
import steve_gall.minecolonies_compatibility.core.common.building.module.AccessDirection;
import steve_gall.minecolonies_compatibility.core.common.inventory.AccessDirectionHolderMenu;
import steve_gall.minecolonies_compatibility.core.common.network.message.AccessDirectionMessage;

public class AccessDirectionHolderScreen
extends AbstractContainerScreen<AccessDirectionHolderMenu<?>> {
    private static final ResourceLocation TEXTURE = MineColoniesCompatibility.rl("textures/gui/access_direction_holder.png");
    private AccessDirectionButton accessDirectionButton;

    public AccessDirectionHolderScreen(AccessDirectionHolderMenu<?> containerMenu, Inventory inventory, Component title) {
        super(containerMenu, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 137;
        this.titleLabelX = 7;
        this.titleLabelY = 7;
        this.inventoryLabelX = 7;
        this.inventoryLabelY = 43;
    }

    protected void init() {
        super.init();
        Object blockEntity = ((AccessDirectionHolderMenu)this.getMenu()).getBlockEntity();
        this.accessDirectionButton = (AccessDirectionButton)this.addRenderableWidget((GuiEventListener)new AccessDirectionButton(this.leftPos - 22, this.topPos, b -> {
            AccessDirection next = ((IAccessDirectionHolder)blockEntity).getAccessDirection().next();
            ((IAccessDirectionHolder)blockEntity).setAccessDirection(next);
            PacketDistributor.sendToServer(new AccessDirectionMessage<BlockEntity>((BlockEntity)blockEntity, next), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        this.accessDirectionButton.setAccessDirection(((IAccessDirectionHolder)blockEntity).getAccessDirection());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Object blockEntity = ((AccessDirectionHolderMenu)this.getMenu()).getBlockEntity();
        guiGraphics.drawString(this.font, NetworkStorageViewScreenUtils.getModuleText(((INetworkStorageViewHolder)blockEntity).getNetworkStorageView()), this.leftPos + 14, this.topPos + 21, -12566464, false);
        if (this.accessDirectionButton != null) {
            AccessDirection accessDirection = ((IAccessDirectionHolder)blockEntity).getAccessDirection();
            this.accessDirectionButton.setAccessDirection(accessDirection);
            if (this.accessDirectionButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(this.font, this.accessDirectionButton.getTooltipText(), mouseX, mouseY);
            }
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }
}

