/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.core.client;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.configuration.ClientConfiguration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import net.neoforged.neoforge.common.NeoForge;
import steve_gall.minecolonies_compatibility.core.client.gui.AccessDirectionHolderScreen;
import steve_gall.minecolonies_compatibility.core.client.gui.BucketFillingTeachScreen;
import steve_gall.minecolonies_compatibility.core.client.gui.SmithingTeachScreen;
import steve_gall.minecolonies_compatibility.core.client.gui.SmithingTemplateInventoryScreen;
import steve_gall.minecolonies_compatibility.core.client.gui.StonecutterTeachScreen;
import steve_gall.minecolonies_compatibility.core.common.init.ModMenuTypes;

public class MineColoniesCompatibilityClient {
    public MineColoniesCompatibilityClient(FMLModContainer modContainer) {
        IEventBus fml_bus = modContainer.getEventBus();
        fml_bus.addListener(this::onRegisterMenuScreens);
        IEventBus forge_bus = NeoForge.EVENT_BUS;
        forge_bus.addListener(EventPriority.HIGH, this::onPlaySoundEvent);
    }

    private void onRegisterMenuScreens(RegisterMenuScreensEvent e) {
        e.register((MenuType)ModMenuTypes.BUCKET_FILLING_TEACH.get(), BucketFillingTeachScreen::new);
        e.register((MenuType)ModMenuTypes.SMITHING_TEACH.get(), SmithingTeachScreen::new);
        e.register((MenuType)ModMenuTypes.SMITHING_TEMPLATE_INVENTORY.get(), SmithingTemplateInventoryScreen::new);
        e.register((MenuType)ModMenuTypes.ACCESS_DIRECTION_HOLDER.get(), AccessDirectionHolderScreen::new);
        e.register((MenuType)ModMenuTypes.STONECUTTING_TEACH.get(), StonecutterTeachScreen::new);
    }

    private void onPlaySoundEvent(PlaySoundEvent event) {
        if (event.getSound() == null) {
            return;
        }
        ResourceLocation soundLocation = event.getSound().getLocation();
        if (!((Boolean)((ClientConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getClient()).citizenVoices.get()).booleanValue() && soundLocation.getNamespace().equals("minecolonies_compatibility") && soundLocation.getPath().startsWith("citizen.")) {
            event.setSound(null);
        }
    }
}

