/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.plant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantSeedContext;

public abstract class CustomizedCrop {
    private static final List<CustomizedCrop> REGISTRY = new ArrayList<CustomizedCrop>();

    public static void register(@NotNull CustomizedCrop crop) {
        REGISTRY.add(crop);
    }

    public static List<CustomizedCrop> getValues() {
        return Collections.unmodifiableList(REGISTRY);
    }

    @Nullable
    public static CustomizedCrop selectBySeed(@NotNull PlantSeedContext context) {
        return REGISTRY.stream().filter(it -> it.isSeed(context)).findFirst().orElse(null);
    }

    @Nullable
    public static CustomizedCrop selectByCrop(@NotNull PlantBlockContext context) {
        return REGISTRY.stream().filter(it -> it.isCrop(context)).findFirst().orElse(null);
    }

    @Nullable
    public BlockState getPlantState(@NotNull PlantSeedContext context) {
        Item item = context.getSeed().getItem();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            return item2.getBlock().defaultBlockState();
        }
        return null;
    }

    public boolean isSeed(@NotNull PlantSeedContext context) {
        return false;
    }

    public boolean isCrop(@NotNull PlantBlockContext context) {
        return false;
    }

    @Nullable
    public SpecialHarvestPositionFunction getSpecialHarvestPosition(@NotNull PlantBlockContext context) {
        return null;
    }

    @Nullable
    public SpecialHarvestMethodFunction getSpecialHarvestMethod(@NotNull PlantBlockContext context) {
        return null;
    }

    public static interface SpecialHarvestMethodFunction {
        @NotNull
        public List<ItemStack> harvest(@NotNull PlantBlockContext var1, @NotNull HarvesterContext var2);
    }

    public static interface SpecialHarvestPositionFunction {
        @Nullable
        public BlockPos apply(@NotNull PlantBlockContext var1);
    }
}

