/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.crafting;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.GenericedRecipeStorage;
import steve_gall.minecolonies_compatibility.api.common.crafting.SimpleGenericRecipe;
import steve_gall.minecolonies_compatibility.core.common.crafting.ItemStorageHelper;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackHelper;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_tweaks.core.common.item.ItemSerializationHelper;
import steve_gall.minecolonies_tweaks.core.common.util.SerializationHelper;

public abstract class SimpleRecipeStorage<GENERIC_RECIPE extends SimpleGenericRecipe>
extends GenericedRecipeStorage<GENERIC_RECIPE> {
    private final ResourceLocation recipeId;
    private final List<ItemStorage> ingredients;
    private final ItemStack output;
    private final List<ItemStack> secondaryOutputs;
    private GENERIC_RECIPE genericRecipe;

    public SimpleRecipeStorage(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag tag) {
        this.recipeId = ResourceLocation.parse((String)tag.getString("recipeId"));
        this.ingredients = NBTUtils2.deserializeList(tag, "ingredients", SerializationHelper.deserializerTag((HolderLookup.Provider)provider));
        this.output = ItemSerializationHelper.deserializeTag((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("output"));
        this.secondaryOutputs = ItemStorageHelper.getCraftingRemainings(this.ingredients);
    }

    public SimpleRecipeStorage(@NotNull ResourceLocation recipeId, @NotNull List<ItemStorage> ingredients, @NotNull ItemStack output) {
        this.recipeId = recipeId;
        this.ingredients = ItemStorageHelper.filterNotEmpty(ingredients);
        this.output = output;
        this.secondaryOutputs = ItemStorageHelper.getCraftingRemainings(ingredients);
    }

    public void serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag tag) {
        tag.putString("recipeId", this.recipeId.toString());
        NBTUtils2.serializeCollection(tag, "ingredients", this.ingredients, SerializationHelper.serializerTag((HolderLookup.Provider)provider));
        tag.put("output", (Tag)ItemSerializationHelper.serializeTag((HolderLookup.Provider)provider, (ItemStack)this.output));
    }

    public int hashCode() {
        return Objects.hash(this.recipeId, this.ingredients, this.output.getItem());
    }

    public boolean equals(@NotNull Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleRecipeStorage) {
            SimpleRecipeStorage other = (SimpleRecipeStorage)o;
            return this.recipeId.equals((Object)other.recipeId) && this.ingredients.equals(other.ingredients) && ItemStackHelper.equals(this.output, other.output);
        }
        return false;
    }

    @NotNull
    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    @NotNull
    public List<ItemStorage> getInput() {
        return this.ingredients;
    }

    @Override
    @NotNull
    public List<ItemStack> getSecondaryOutputs() {
        return this.secondaryOutputs;
    }

    @NotNull
    public List<ItemStorage> getIngredients() {
        return this.ingredients;
    }

    @Override
    @NotNull
    public GENERIC_RECIPE getGenericRecipe() {
        if (this.genericRecipe == null) {
            this.genericRecipe = (SimpleGenericRecipe)this.getGenericRecipeFactory().create(this.recipeId, ItemStorageHelper.getStacksLists(this.ingredients), this.output);
        }
        return this.genericRecipe;
    }

    @NotNull
    protected abstract GenericRecipeFactory<GENERIC_RECIPE> getGenericRecipeFactory();

    public static interface GenericRecipeFactory<GENERIC_RECIPE> {
        @NotNull
        public GENERIC_RECIPE create(@NotNull ResourceLocation var1, @NotNull List<List<ItemStack>> var2, @NotNull ItemStack var3);
    }
}

