/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.api.common.crafting;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.RecipeCraftingType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleCraftingType<RECIPE_INPUT extends RecipeInput, RECIPE extends Recipe<RECIPE_INPUT>, GENERIC_RECIPE extends IGenericRecipe>
extends RecipeCraftingType<RECIPE_INPUT, RECIPE> {
    @NotNull
    private final Supplier<RecipeType<RECIPE>> recipeType;
    @NotNull
    private final BiFunction<RecipeHolder<RECIPE>, HolderLookup.Provider, GENERIC_RECIPE> genericRecipeFunc;

    public SimpleCraftingType(@NotNull ResourceLocation id, @NotNull Supplier<RecipeType<RECIPE>> recipeType, @NotNull BiFunction<RecipeHolder<RECIPE>, HolderLookup.Provider, GENERIC_RECIPE> genericRecipeFunc) {
        super(id, null, null);
        this.recipeType = recipeType;
        this.genericRecipeFunc = genericRecipeFunc;
    }

    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull RecipeManager recipeManager, @Nullable Level world) {
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        RegistryAccess registryAccess = world.registryAccess();
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor(this.getRecipeType())) {
            if (!this.testRecipe(recipe.value(), (HolderLookup.Provider)registryAccess)) continue;
            recipes.add((IGenericRecipe)this.createGenericRecipe(recipe, (HolderLookup.Provider)registryAccess));
        }
        return recipes;
    }

    protected boolean testRecipe(@NotNull RECIPE recipe, @NotNull HolderLookup.Provider provider) {
        return true;
    }

    @NotNull
    protected GENERIC_RECIPE createGenericRecipe(@NotNull RecipeHolder<RECIPE> holder, @NotNull HolderLookup.Provider provider) {
        return (GENERIC_RECIPE)((IGenericRecipe)this.genericRecipeFunc.apply(holder, provider));
    }

    @NotNull
    public RecipeType<RECIPE> getRecipeType() {
        return this.recipeType.get();
    }
}

