/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collection;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.distribution.EnergyAcceptorTarget;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.lib.distribution.Target;
import mekanism.common.util.EmitUtils;

public final class CableUtils {
    private CableUtils() {
    }

    public static void emit(Collection<BlockEnergyCapabilityCache> targets, IEnergyContainer energyContainer) {
        CableUtils.emit(targets, energyContainer, energyContainer.getMaxEnergy());
    }

    public static void emit(Collection<BlockEnergyCapabilityCache> targets, IEnergyContainer energyContainer, long maxOutput) {
        if (!energyContainer.isEmpty() && maxOutput > 0L) {
            energyContainer.extract(CableUtils.emit(targets, 0L, energyContainer, maxOutput), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static long emit(Collection<BlockEnergyCapabilityCache> targets, long energyToSend) {
        return CableUtils.emit(targets, energyToSend, null, energyToSend);
    }

    private static long emit(Collection<BlockEnergyCapabilityCache> targets, long energyToSend, IEnergyContainer energyContainer, long maxOutput) {
        if (energyToSend == 0L && energyContainer == null) {
            return 0L;
        }
        if (energyToSend < 0L || targets.isEmpty()) {
            return 0L;
        }
        Target target = null;
        for (BlockEnergyCapabilityCache capability : targets) {
            IStrictEnergyHandler handler = capability.getCapability();
            if (handler == null) continue;
            if (energyToSend == 0L && (energyToSend = energyContainer.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL)) <= 0L) {
                return 0L;
            }
            if (target == null) {
                target = new EnergyAcceptorTarget(targets.size());
            }
            target.addHandler(handler);
        }
        return EmitUtils.sendToAcceptors(target, energyToSend, EnergyNetwork.ENERGY);
    }
}

