/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.configuration_update;

import io.netty.buffer.ByteBuf;
import mekanism.api.RelativeSide;
import mekanism.common.Mekanism;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.MekClickType;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketSideData(BlockPos pos, MekClickType clickType, RelativeSide inputSide, TransmissionType transmission) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketSideData> TYPE = new CustomPacketPayload.Type(Mekanism.rl("side_data"));
    public static final StreamCodec<ByteBuf, PacketSideData> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketSideData::pos, MekClickType.STREAM_CODEC, PacketSideData::clickType, RelativeSide.STREAM_CODEC, PacketSideData::inputSide, TransmissionType.STREAM_CODEC, PacketSideData::transmission, PacketSideData::new);

    @NotNull
    public CustomPacketPayload.Type<PacketSideData> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        ConfigInfo info;
        TileComponentConfig configComponent = PacketUtils.config(context, this.pos);
        if (configComponent != null && (info = configComponent.getConfig(this.transmission)) != null) {
            boolean changed;
            DataType type = info.getDataType(this.inputSide);
            boolean bl = changed = type != (switch (this.clickType) {
                default -> throw new MatchException(null, null);
                case MekClickType.LEFT -> info.incrementDataType(this.inputSide);
                case MekClickType.RIGHT -> info.decrementDataType(this.inputSide);
                case MekClickType.SHIFT_LEFT -> {
                    if (type != DataType.NONE) {
                        info.setDataType(DataType.NONE, this.inputSide);
                    }
                    yield DataType.NONE;
                }
            });
            if (changed) {
                configComponent.sideChanged(this.transmission, this.inputSide);
            }
        }
    }
}

