/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.SequencedCollection;
import java.util.function.Function;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.basic.BasicSawmillRecipe;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

@RecipeTypeMapper
public class SawmillRecipeMapper
extends TypedMekanismRecipeMapper<SawmillRecipe> {
    public SawmillRecipeMapper() {
        super(MekanismConfigTranslations.PE_MAPPER_SAWING, SawmillRecipe.class, MekanismRecipeType.SAWING);
    }

    public boolean isAvailable() {
        return false;
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, SawmillRecipe recipe, TypedMekanismRecipeMapper.MekFakeGroupHelper fakeGroupHelper) {
        int secondaryMultiplier;
        int primaryMultiplier;
        if (recipe.getSecondaryChance() > 0.0 && recipe.getSecondaryChance() < 1.0) {
            Fraction multiplier;
            try {
                multiplier = Fraction.getFraction((double)recipe.getSecondaryChance()).invert();
            }
            catch (ArithmeticException e) {
                return false;
            }
            primaryMultiplier = multiplier.getNumerator();
            secondaryMultiplier = multiplier.getDenominator();
        } else {
            primaryMultiplier = 1;
            secondaryMultiplier = 1;
        }
        if (recipe instanceof BasicSawmillRecipe) {
            BasicSawmillRecipe basicRecipe = (BasicSawmillRecipe)recipe;
            Object2IntMap<NormalizedSimpleStack> ingredients = fakeGroupHelper.forIngredient(recipe.getInput());
            if (ingredients.isEmpty()) {
                return false;
            }
            if (primaryMultiplier > 1) {
                ingredients = SawmillRecipeMapper.insertScaled((Object2IntMap<NormalizedSimpleStack>)new Object2IntArrayMap(ingredients.size()), ingredients, primaryMultiplier);
            }
            SawmillOutput output2 = SawmillOutput.create(basicRecipe.getMainOutputRaw().orElse(ItemStack.EMPTY), basicRecipe.getSecondaryOutputRaw().orElse(ItemStack.EMPTY), primaryMultiplier, secondaryMultiplier);
            return SawmillRecipeMapper.addConversions(mapper, output2, ingredients);
        }
        Function<SequencedCollection<Object>, Object> representationGetter = primaryMultiplier == 1 ? fakeGroupHelper::forItems : representations -> {
            Object2IntMap<NormalizedSimpleStack> ingredients = fakeGroupHelper.forItems((SequencedCollection<ItemStack>)representations);
            return SawmillRecipeMapper.insertScaled((Object2IntMap<NormalizedSimpleStack>)new Object2IntArrayMap(ingredients.size()), ingredients, primaryMultiplier);
        };
        return SawmillRecipeMapper.addConversions(mapper, recipe.getInput(), input -> SawmillOutput.create(recipe.getOutput((ItemStack)input), primaryMultiplier, secondaryMultiplier), output -> output.mainOutput().isEmpty(), representationGetter, null, SawmillRecipeMapper::addConversions);
    }

    private static boolean addConversions(IMappingCollector<NormalizedSimpleStack, Long> mapper, SawmillOutput output, Object2IntMap<NormalizedSimpleStack> inputs) {
        ItemStack mainOutput = output.mainOutput();
        if (inputs.isEmpty() || mainOutput.isEmpty()) {
            return false;
        }
        ItemStack secondaryOutput = output.secondaryOutput();
        if (secondaryOutput.isEmpty()) {
            return SawmillRecipeMapper.addConversion(mapper, mainOutput, inputs);
        }
        return SawmillRecipeMapper.addConversion(mapper, mainOutput, SawmillRecipeMapper.forIngredients(inputs, (NormalizedSimpleStack)NSSItem.createItem((ItemStack)secondaryOutput), -secondaryOutput.getCount())) | SawmillRecipeMapper.addConversion(mapper, secondaryOutput, SawmillRecipeMapper.forIngredients(inputs, (NormalizedSimpleStack)NSSItem.createItem((ItemStack)mainOutput), -mainOutput.getCount()));
    }

    private record SawmillOutput(ItemStack mainOutput, ItemStack secondaryOutput) {
        public static SawmillOutput create(ItemStack mainOutput, ItemStack secondaryOutput, int primaryMultiplier, int secondaryMultiplier) {
            if (!secondaryOutput.isEmpty() && secondaryMultiplier > 1) {
                secondaryOutput = secondaryOutput.copyWithCount(secondaryMultiplier * secondaryOutput.getCount());
            }
            if (mainOutput.isEmpty()) {
                return new SawmillOutput(secondaryOutput, ItemStack.EMPTY);
            }
            if (primaryMultiplier > 1) {
                mainOutput = mainOutput.copyWithCount(primaryMultiplier * mainOutput.getCount());
            }
            return new SawmillOutput(mainOutput, secondaryOutput);
        }

        public static SawmillOutput create(SawmillRecipe.ChanceOutput output, int primaryMultiplier, int secondaryMultiplier) {
            return SawmillOutput.create(output.getMainOutput(), output.getMaxSecondaryOutput(), primaryMultiplier, secondaryMultiplier);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SawmillOutput other = (SawmillOutput)o;
            return ItemStack.matches((ItemStack)this.mainOutput, (ItemStack)other.mainOutput) && ItemStack.matches((ItemStack)this.secondaryOutput, (ItemStack)other.secondaryOutput);
        }

        @Override
        public int hashCode() {
            int hash = ItemStack.hashItemAndComponents((ItemStack)this.mainOutput);
            hash = 31 * hash + this.mainOutput.getCount();
            if (!this.secondaryOutput.isEmpty()) {
                hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.secondaryOutput);
                hash = 31 * hash + this.secondaryOutput.getCount();
            }
            return hash;
        }
    }
}

