/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.lang.invoke.CallSite;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mekanism.common.integration.computer.BaseComputerHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.ComputerMethodFactory;
import mekanism.common.integration.computer.MethodData;
import mekanism.common.integration.computer.MethodHelpData;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public abstract class BoundMethodHolder {
    private static final Comparator<BoundMethodData<?>> METHODDATA_COMPARATOR = Comparator.comparing(BoundMethodData::name).thenComparing(md -> md.argumentNames().length);
    private static final MethodData<ListMultimap<String, BoundMethodData<?>>> HELP_METHOD = MethodData.builder("help", BoundMethodHolder::generateHelp).returnType(Map.class).returnExtra(String.class, MethodHelpData.class).build();
    private static final MethodData<ListMultimap<String, BoundMethodData<?>>> HELP_METHOD_WITH_NAME = MethodData.builder("help", BoundMethodHolder::generateHelpSpecific).returnType(Map.class).returnExtra(String.class, MethodHelpData.class).arguments(new String[]{"methodName"}, new Class[]{String.class}).build();
    protected final ListMultimap<String, BoundMethodData<?>> methods = ArrayListMultimap.create();
    private final Set<ObjectIntPair<String>> methodsKnown = new HashSet<ObjectIntPair<String>>();
    protected Lazy<String[]> methodNames = Lazy.of(() -> (String[])this.methods.keys().toArray((Object[])new String[0]));

    protected BoundMethodHolder() {
        this.register(HELP_METHOD, new WeakReference(this.methods), true);
        this.register(HELP_METHOD_WITH_NAME, new WeakReference(this.methods), true);
    }

    public <T> void register(MethodData<T> method, @Nullable WeakReference<T> subject, boolean isHelpMethod) {
        if (!this.methodsKnown.add((ObjectIntPair<String>)new ObjectIntImmutablePair((Object)method.name(), method.argumentNames().length))) {
            throw new RuntimeException("Duplicate method name " + method.name() + "_" + method.argumentNames().length);
        }
        this.methods.put((Object)method.name(), new BoundMethodData<T>(method, subject, isHelpMethod));
    }

    public static Object generateHelp(ListMultimap<String, BoundMethodData<?>> methods, BaseComputerHelper helper) {
        if (methods == null) {
            return helper.voidResult();
        }
        Map<String, MethodHelpData> helpItems = methods.values().stream().sorted(METHODDATA_COMPARATOR).collect(Collectors.toMap(md -> md.name() + "(" + String.join((CharSequence)", ", md.argumentNames()) + ")", MethodHelpData::from, (a, b) -> b));
        return helper.convert(helpItems, helper::convert, helper::convert);
    }

    public static Object generateHelpSpecific(ListMultimap<String, BoundMethodData<?>> methods, BaseComputerHelper helper) throws ComputerException {
        if (methods == null) {
            return helper.voidResult();
        }
        String methodName = helper.getString(0);
        ArrayList toSort = new ArrayList(methods.values());
        toSort.sort(METHODDATA_COMPARATOR);
        HashMap<CallSite, MethodHelpData> helpItems = new HashMap<CallSite, MethodHelpData>();
        for (BoundMethodData boundMethodData : toSort) {
            if (!boundMethodData.name().equalsIgnoreCase(methodName)) continue;
            helpItems.put((CallSite)((Object)(boundMethodData.name() + "(" + String.join((CharSequence)", ", boundMethodData.argumentNames()) + ")")), MethodHelpData.from(boundMethodData));
        }
        if (helpItems.isEmpty()) {
            return helper.convert("Method name not found: " + methodName);
        }
        return helper.convert(helpItems, helper::convert, helper::convert);
    }

    public record BoundMethodData<T>(MethodData<T> method, @Nullable WeakReference<T> subject, boolean isHelpMethod) {
        public Object call(BaseComputerHelper helper) throws ComputerException {
            return this.method.handler().apply(this.unwrappedSubject(), helper);
        }

        @Nullable
        private T unwrappedSubject() {
            return this.subject == null ? null : (T)this.subject.get();
        }

        public String name() {
            return this.method.name();
        }

        public boolean threadSafe() {
            return this.method.threadSafe();
        }

        public String[] argumentNames() {
            return this.method.argumentNames();
        }

        public Class<?>[] argClasses() {
            return this.method.argClasses();
        }

        public Class<?> returnType() {
            return this.method.returnType();
        }

        public ComputerMethodFactory.ComputerFunctionCaller<T> handler() {
            return this.method.handler();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BoundMethodData)) return false;
            BoundMethodData that = (BoundMethodData)o;
            if (!this.method.equals(that.method)) return false;
            if (!this.subjectEquals(that)) return false;
            return true;
        }

        private boolean subjectEquals(BoundMethodData<?> that) {
            T mySubject = this.unwrappedSubject();
            Object otherSubject = that.unwrappedSubject();
            if (this.isHelpMethod) {
                return mySubject == otherSubject;
            }
            return Objects.equals(mySubject, otherSubject);
        }

        @Override
        public int hashCode() {
            int result = this.method.hashCode();
            T subject = this.unwrappedSubject();
            result = 31 * result + (subject == null ? 0 : subject.hashCode());
            return result;
        }
    }
}

