/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.MekanismPermissions;
import mekanism.common.config.MekanismConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ForceRetrogenCommand {
    private static final SimpleCommandExceptionType RETROGEN_NOT_ENABLED = new SimpleCommandExceptionType((Message)MekanismLang.COMMAND_ERROR_RETROGEN_DISABLED.translate());
    private static final SimpleCommandExceptionType NO_CHUNKS_QUEUED = new SimpleCommandExceptionType((Message)MekanismLang.COMMAND_ERROR_RETROGEN_FAILURE.translate());

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"retrogen").requires((Predicate)MekanismPermissions.COMMAND_FORCE_RETROGEN)).executes(ctx -> {
            BlockPos blockPos = BlockPos.containing((Position)((CommandSourceStack)ctx.getSource()).getPosition());
            ColumnPos pos = new ColumnPos(blockPos.getX(), blockPos.getZ());
            return ForceRetrogenCommand.addChunksToRegen((CommandSourceStack)ctx.getSource(), pos, pos);
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"from", (ArgumentType)ColumnPosArgument.columnPos()).executes(ctx -> {
            ColumnPos from = ColumnPosArgument.getColumnPos((CommandContext)ctx, (String)"from");
            return ForceRetrogenCommand.addChunksToRegen((CommandSourceStack)ctx.getSource(), from, from);
        })).then(Commands.argument((String)"to", (ArgumentType)ColumnPosArgument.columnPos()).executes(ctx -> ForceRetrogenCommand.addChunksToRegen((CommandSourceStack)ctx.getSource(), ColumnPosArgument.getColumnPos((CommandContext)ctx, (String)"from"), ColumnPosArgument.getColumnPos((CommandContext)ctx, (String)"to")))));
    }

    private static int addChunksToRegen(CommandSourceStack source, ColumnPos start, ColumnPos end) throws CommandSyntaxException {
        if (!MekanismConfig.world.enableRegeneration.get()) {
            throw RETROGEN_NOT_ENABLED.create();
        }
        int xStart = Math.min(start.x(), end.x());
        int xEnd = Math.max(start.x(), end.x());
        int zStart = Math.min(start.z(), end.z());
        int zEnd = Math.max(start.z(), end.z());
        if (xStart < -30000000 || zStart < -30000000 || xEnd >= 30000000 || zEnd >= 30000000) {
            throw BlockPosArgument.ERROR_OUT_OF_WORLD.create();
        }
        int chunkXStart = SectionPos.blockToSectionCoord((int)xStart);
        int chunkXEnd = SectionPos.blockToSectionCoord((int)xEnd);
        int chunkZStart = SectionPos.blockToSectionCoord((int)zStart);
        int chunkZEnd = SectionPos.blockToSectionCoord((int)zEnd);
        ServerLevel world = source.getLevel();
        ResourceKey registryKey = world.dimension();
        int chunks = 0;
        for (int chunkX = chunkXStart; chunkX <= chunkXEnd; ++chunkX) {
            for (int chunkZ = chunkZStart; chunkZ <= chunkZEnd; ++chunkZ) {
                if (!world.hasChunk(chunkX, chunkZ)) continue;
                Mekanism.worldTickHandler.addRegenChunk((ResourceKey<Level>)registryKey, new ChunkPos(chunkX, chunkZ));
                int finalChunkX = chunkX;
                int finalChunkZ = chunkZ;
                source.sendSuccess(() -> MekanismLang.COMMAND_RETROGEN_CHUNK_QUEUED.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismLang.GENERIC_WITH_COMMA.translate(finalChunkX, finalChunkZ), EnumColor.INDIGO, world), true);
                ++chunks;
            }
        }
        if (chunks == 0) {
            throw NO_CHUNKS_QUEUED.create();
        }
        return chunks;
    }
}

