/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.energy;

import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.math.MathUtils;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class MinerEnergyContainer
extends MachineEnergyContainer<TileEntityDigitalMiner> {
    private long minerEnergyPerTick = this.getBaseEnergyPerTick();

    public static MinerEnergyContainer input(TileEntityDigitalMiner tile, @Nullable IContentsListener listener) {
        AttributeEnergy electricBlock = MinerEnergyContainer.validateBlock(tile);
        return new MinerEnergyContainer(electricBlock.getStorage(), electricBlock.getUsage(), tile, listener);
    }

    private MinerEnergyContainer(long maxEnergy, long energyPerTick, TileEntityDigitalMiner tile, @Nullable IContentsListener listener) {
        super(maxEnergy, energyPerTick, notExternal, ConstantPredicates.alwaysTrue(), tile, listener);
    }

    @Override
    public void setEnergyPerTick(long energyPerTick) {
        super.setEnergyPerTick(energyPerTick);
        this.minerEnergyPerTick = energyPerTick;
    }

    @Override
    public long getEnergyPerTick() {
        return this.minerEnergyPerTick;
    }

    @Override
    public void updateEnergyPerTick() {
        super.updateEnergyPerTick();
        this.updateMinerEnergyPerTick();
    }

    public void updateMinerEnergyPerTick() {
        this.minerEnergyPerTick = super.getEnergyPerTick();
        if (((TileEntityDigitalMiner)this.tile).getSilkTouch()) {
            this.minerEnergyPerTick = MathUtils.multiplyClamped(this.minerEnergyPerTick, MekanismConfig.general.minerSilkMultiplier.get());
        }
        double radiusRange = MekanismConfig.general.minerMaxRadius.get() - 10;
        Level level = ((TileEntityDigitalMiner)this.tile).getLevel();
        double heightRange = level == null ? 195.0 : (double)(level.getHeight() - 1 - 60);
        double radiusCost = radiusRange == 0.0 ? 0.0 : Math.max((double)(((TileEntityDigitalMiner)this.tile).getRadius() - 10) / radiusRange, 0.0);
        double heightCost = heightRange == 0.0 ? 0.0 : Math.max((double)(((TileEntityDigitalMiner)this.tile).getMaxY() - ((TileEntityDigitalMiner)this.tile).getMinY() - 60) / heightRange, 0.0);
        this.minerEnergyPerTick = MathUtils.ceilToLong((double)this.minerEnergyPerTick * (1.0 + radiusCost) * (1.0 + heightCost));
    }
}

