/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class CapabilityCache {
    private final Map<BlockCapability<?, @Nullable Direction>, ICapabilityResolver<@Nullable Direction>> capabilityResolvers = new IdentityHashMap();
    private final List<ICapabilityResolver<?>> uniqueResolvers = new ArrayList();
    @Nullable
    private TileComponentConfig config;

    public void addCapabilityResolver(ICapabilityResolver<@Nullable Direction> resolver) {
        this.uniqueResolvers.add(resolver);
        List<BlockCapability<?, @Nullable Direction>> supportedCapabilities = resolver.getSupportedCapabilities();
        for (BlockCapability<?, Direction> supportedCapability : supportedCapabilities) {
            if (this.capabilityResolvers.put(supportedCapability, resolver) == null) continue;
            Mekanism.logger.warn("Multiple capability resolvers registered for {}. Overriding", (Object)supportedCapability.name(), (Object)new Exception());
        }
    }

    public void addConfigComponent(TileComponentConfig config) {
        if (this.config != null) {
            Mekanism.logger.warn("Config component already registered. Overriding", (Throwable)new Exception());
        }
        this.config = config;
    }

    public boolean isCapabilityDisabled(BlockCapability<?, @Nullable Direction> capability, @Nullable Direction side) {
        return this.config != null && this.config.isCapabilityDisabled(capability, side);
    }

    @Nullable
    public @Nullable ICapabilityResolver<@Nullable Direction> getResolver(BlockCapability<?, @Nullable Direction> capability) {
        return this.capabilityResolvers.get(capability);
    }

    public ICapabilityResolver<@Nullable Direction> getResolver(BlockCapability<?, @Nullable Direction> capability, Supplier<ICapabilityResolver<@Nullable Direction>> resolver) {
        ICapabilityResolver<@Nullable Direction> knownResolver = this.getResolver(capability);
        if (knownResolver == null) {
            knownResolver = resolver.get();
            this.addCapabilityResolver(knownResolver);
        }
        return knownResolver;
    }

    public void invalidate(BlockCapability<?, @Nullable Direction> capability, @Nullable Direction side) {
        ICapabilityResolver<@Nullable Direction> capabilityResolver = this.capabilityResolvers.get(capability);
        if (capabilityResolver != null) {
            capabilityResolver.invalidate(capability, side);
        }
    }

    public void invalidateAll(BlockCapability<?, @Nullable Direction> capability) {
        ICapabilityResolver<@Nullable Direction> capabilityResolver = this.capabilityResolvers.get(capability);
        if (capabilityResolver != null) {
            capabilityResolver.invalidateAll();
        }
    }

    public void invalidateAll() {
        this.uniqueResolvers.forEach(ICapabilityResolver::invalidateAll);
    }
}

