/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.interfaces;

import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IHasTileEntity<TILE extends BlockEntity>
extends EntityBlock {
    public TileEntityTypeRegistryObject<? extends TILE> getTileType();

    default public TILE newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return (TILE)((BlockEntityType)this.getTileType().get()).create(pos, state);
    }

    @Nullable
    default public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        TileEntityTypeRegistryObject<TILE> type = this.getTileType();
        return blockEntityType == type.get() ? type.getTicker(level.isClientSide) : null;
    }

    default public boolean triggerBlockEntityEvent(@NotNull BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity blockEntity = WorldUtils.getTileEntity((BlockGetter)level, pos);
        return blockEntity != null && blockEntity.triggerEvent(id, param);
    }
}

