/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.robit;

import mekanism.client.gui.element.text.BackgroundType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.robit.GuiRobit;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.entity.robit.RepairRobitContainer;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GuiRobitRepair
extends GuiRobit<RepairRobitContainer>
implements ContainerListener {
    private static final ResourceLocation TEXT_FIELD_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/anvil/text_field");
    private static final ResourceLocation TEXT_FIELD_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/anvil/text_field_disabled");
    private static final ResourceLocation ERROR_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/anvil/error");
    private static final ResourceLocation ANVIL_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/anvil.png");
    private final Player player;
    private GuiTextField itemNameField;
    private long msDisplayCost;

    public GuiRobitRepair(RepairRobitContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.player = inv.player;
        ++this.inventoryLabelY;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.itemNameField = this.addRenderableWidget(new GuiTextField(this, 60, 21, 103, 12));
        this.itemNameField.setCanLoseFocus(false);
        this.itemNameField.setTextColor(-1);
        this.itemNameField.setTextColorUneditable(-1);
        this.itemNameField.setBackground(BackgroundType.NONE);
        this.itemNameField.setMaxLength(50);
        this.itemNameField.setResponder(this::onNameChanged);
        this.itemNameField.setEditable(((RepairRobitContainer)this.menu).getSlot(0).hasItem());
        this.setInitialFocus((GuiEventListener)this.itemNameField);
        ((RepairRobitContainer)this.menu).removeSlotListener(this);
        ((RepairRobitContainer)this.menu).addSlotListener(this);
    }

    @Override
    protected void setInitialFocus(@NotNull GuiEventListener listener) {
        this.initialFocusSet = false;
        super.setInitialFocus(listener);
    }

    private void onNameChanged(String newText) {
        if (!newText.isEmpty()) {
            Slot slot = ((RepairRobitContainer)this.menu).getSlot(0);
            if (slot.hasItem() && !slot.getItem().has(DataComponents.CUSTOM_NAME) && newText.equals(slot.getItem().getHoverName().getString())) {
                newText = "";
            }
            if (((RepairRobitContainer)this.menu).setItemName(newText)) {
                this.getMinecraft().player.connection.send((Packet)new ServerboundRenameItemPacket(newText));
            }
        }
    }

    @Override
    public void removed() {
        super.removed();
        ((RepairRobitContainer)this.menu).removeSlotListener(this);
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleTextWithOffset(guiGraphics, this.itemNameField.getRelativeX(), this.itemNameField.getRelativeRight() + 4, 0, IFancyFontRenderer.TextAlignment.CENTER);
        this.renderInventoryText(guiGraphics, 60);
        int maximumCost = ((RepairRobitContainer)this.menu).getCost();
        if (maximumCost > 0) {
            if (this.msDisplayCost == 0L) {
                this.msDisplayCost = Util.getMillis();
            }
            int textColor = 8453920;
            MutableComponent component = MekanismLang.REPAIR_COST.translate(maximumCost);
            if (maximumCost >= 40 && !this.getMinecraft().player.getAbilities().instabuild) {
                component = MekanismLang.REPAIR_EXPENSIVE.translate();
                textColor = 0xFF6060;
            } else {
                Slot slot = ((RepairRobitContainer)this.menu).getSlot(2);
                if (!slot.hasItem()) {
                    component = null;
                    this.msDisplayCost = 0L;
                } else if (!slot.mayPickup(this.player)) {
                    textColor = 0xFF6060;
                }
            }
            if (component != null) {
                int min = Math.max(this.itemNameField.getRelativeX(), this.imageWidth - this.font().width((FormattedText)component) - 10);
                int max = this.imageWidth - 8;
                guiGraphics.fill(min, 67, max, 79, 0x4F000000);
                this.drawScrollingString(guiGraphics, (Component)component, min, 69, IFancyFontRenderer.TextAlignment.RIGHT, textColor, max - min, 1, true, this.msDisplayCost);
            }
        } else {
            this.msDisplayCost = 0L;
        }
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected boolean shouldOpenGui(GuiRobit.RobitGuiType guiType) {
        return guiType != GuiRobit.RobitGuiType.REPAIR;
    }

    @Override
    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(ANVIL_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.blitSprite(((RepairRobitContainer)this.menu).getSlot(0).hasItem() ? TEXT_FIELD_SPRITE : TEXT_FIELD_DISABLED_SPRITE, this.leftPos + 59, this.topPos + 20, 110, 16);
        if ((((RepairRobitContainer)this.menu).getSlot(0).hasItem() || ((RepairRobitContainer)this.menu).getSlot(1).hasItem()) && !((RepairRobitContainer)this.menu).getSlot(2).hasItem()) {
            guiGraphics.blitSprite(ERROR_SPRITE, this.leftPos + 99, this.topPos + 45, 28, 21);
        }
    }

    public void slotChanged(@NotNull AbstractContainerMenu container, int slotID, @NotNull ItemStack stack) {
        if (slotID == 0) {
            this.itemNameField.setText(stack.isEmpty() ? "" : stack.getHoverName().getString());
            this.itemNameField.setEditable(!stack.isEmpty());
            this.setFocused((GuiEventListener)this.itemNameField);
        }
    }

    public void dataChanged(@NotNull AbstractContainerMenu container, int slotID, int value) {
    }
}

