/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import java.util.List;
import mekanism.client.gui.GuiFilterHolder;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDigitalSwitch;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TooltipToggleButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.filter.miner.GuiMinerFilerSelect;
import mekanism.client.gui.element.window.filter.miner.GuiMinerItemStackFilter;
import mekanism.client.gui.element.window.filter.miner.GuiMinerModIDFilter;
import mekanism.client.gui.element.window.filter.miner.GuiMinerTagFilter;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.MinerItemStackFilter;
import mekanism.common.content.miner.MinerModIDFilter;
import mekanism.common.content.miner.MinerTagFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.network.to_server.button.PacketTileButtonPress;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.InputValidator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiDigitalMinerConfig
extends GuiFilterHolder<MinerFilter<?>, TileEntityDigitalMiner, MekanismTileContainer<TileEntityDigitalMiner>> {
    private static final ResourceLocation INVERSE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/inverse.png");
    private final int maxHeightLength;
    private GuiTextField radiusField;
    private GuiTextField minField;
    private GuiTextField maxField;

    public GuiDigitalMinerConfig(MekanismTileContainer<TileEntityDigitalMiner> container, Inventory inv, Component title) {
        super(container, inv, title);
        Level level = inv.player.level();
        this.maxHeightLength = Math.max(Integer.toString(level.getMinBuildHeight()).length(), Integer.toString(level.getMaxBuildHeight() - 1).length());
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new TranslationButton((IGuiWrapper)this, 96, 136, 156, 20, MekanismLang.BUTTON_NEW_FILTER, (element, mouseX, mouseY) -> {
            GuiDigitalMinerConfig gui = (GuiDigitalMinerConfig)element.gui();
            gui.addWindow(new GuiMinerFilerSelect(gui, (TileEntityDigitalMiner)gui.tile));
            return true;
        }));
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 5, 5, 11, 14, this.getButtonLocation("back"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketTileButtonPress(PacketTileButtonPress.ClickedTileButton.BACK_BUTTON, ((GuiDigitalMinerConfig)element.gui()).tile)))).setTooltip(TooltipUtils.BACK);
        this.addRenderableWidget(new GuiDigitalSwitch(this, 10, 115, INVERSE, ((TileEntityDigitalMiner)this.tile)::getInverse, (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.INVERSE_BUTTON, ((GuiDigitalMinerConfig)element.gui()).tile)), GuiDigitalSwitch.SwitchType.LEFT_ICON)).setTooltip(MekanismLang.MINER_INVERSE);
        this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, 13, 135)).setRenderAboveSlots().setRenderHover(true).stored(() -> new ItemStack((ItemLike)((TileEntityDigitalMiner)this.tile).getInverseReplaceTarget())).click((element, mouseX, mouseY) -> {
            GuiDigitalMinerConfig gui = (GuiDigitalMinerConfig)element.gui();
            if (GuiDigitalMinerConfig.hasShiftDown()) {
                gui.updateInverseReplaceTarget(Items.AIR);
                return true;
            }
            ItemStack stack = gui.getCarriedItem();
            if (!stack.isEmpty() && stack.getItem() instanceof BlockItem) {
                gui.updateInverseReplaceTarget(stack.getItem());
                return true;
            }
            return false;
        }).setGhostHandler(ingredient -> {
            this.updateInverseReplaceTarget(((ItemStack)ingredient).getItem());
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        });
        this.addRenderableWidget(new TooltipToggleButton((IGuiWrapper)this, 35, 137, 14, 16, this.getButtonLocation("exclamation"), ((TileEntityDigitalMiner)this.tile)::getInverseRequiresReplacement, (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.INVERSE_REQUIRES_REPLACEMENT_BUTTON, ((GuiDigitalMinerConfig)element.gui()).tile)), (Component)MekanismLang.MINER_REQUIRE_REPLACE_INVERSE.translate(BooleanStateDisplay.YesNo.YES), (Component)MekanismLang.MINER_REQUIRE_REPLACE_INVERSE.translate(BooleanStateDisplay.YesNo.NO)));
        this.radiusField = this.addRenderableWidget(new GuiTextField(this, 13, 45, 38, 11));
        this.radiusField.setMaxLength(Integer.toString(MekanismConfig.general.minerMaxRadius.get()).length());
        this.radiusField.setInputValidator(InputValidator.DIGIT);
        this.radiusField.configureDigitalBorderInput(() -> this.setText(this.radiusField, PacketGuiInteract.GuiInteraction.SET_RADIUS));
        this.minField = this.addRenderableWidget(new GuiTextField(this, 13, 71, 38, 11));
        this.minField.setMaxLength(this.maxHeightLength);
        this.minField.setInputValidator(InputValidator.DIGIT_OR_NEGATIVE);
        this.minField.configureDigitalBorderInput(() -> this.setText(this.minField, PacketGuiInteract.GuiInteraction.SET_MIN_Y));
        this.maxField = this.addRenderableWidget(new GuiTextField(this, 13, 98, 38, 11));
        this.maxField.setMaxLength(this.maxHeightLength);
        this.maxField.setInputValidator(InputValidator.DIGIT_OR_NEGATIVE);
        this.maxField.configureDigitalBorderInput(() -> this.setText(this.maxField, PacketGuiInteract.GuiInteraction.SET_MAX_Y));
        this.trackWarning(WarningTracker.WarningType.FILTER_HAS_BLACKLISTED_ELEMENT, () -> ((TileEntityDigitalMiner)this.tile).getFilterManager().anyEnabledMatch(MinerFilter::hasBlacklistedElement));
    }

    private void updateInverseReplaceTarget(Item target) {
        PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.DIGITAL_MINER_INVERSE_REPLACE_ITEM, (BlockEntity)this.tile, new ItemStack((ItemLike)target)));
    }

    @Override
    protected void addGenericTabs() {
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
        this.renderTitleTextWithOffset(guiGraphics, 14);
        this.drawScreenText(guiGraphics, (Component)MekanismLang.FILTER_COUNT.translate(this.getFilterManager().count()), 5);
        this.drawScreenText(guiGraphics, (Component)MekanismLang.MINER_RADIUS.translate(((TileEntityDigitalMiner)this.tile).getRadius()), 18);
        this.drawScreenText(guiGraphics, (Component)MekanismLang.MIN_DIGITAL_MINER.translate(((TileEntityDigitalMiner)this.tile).getMinY()), 44);
        this.drawScreenText(guiGraphics, (Component)MekanismLang.MAX_DIGITAL_MINER.translate(((TileEntityDigitalMiner)this.tile).getMaxY()), 71);
    }

    @Override
    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof IItemStackFilter) {
            this.addWindow(GuiMinerItemStackFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerItemStackFilter)filter));
        } else if (filter instanceof ITagFilter) {
            this.addWindow(GuiMinerTagFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerTagFilter)filter));
        } else if (filter instanceof IModIDFilter) {
            this.addWindow(GuiMinerModIDFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerModIDFilter)filter));
        }
    }

    @Override
    protected FilterButton addFilterButton(FilterButton button) {
        return super.addFilterButton(button).warning(WarningTracker.WarningType.FILTER_HAS_BLACKLISTED_ELEMENT, filter -> {
            if (!(filter instanceof MinerFilter)) return false;
            MinerFilter minerFilter = (MinerFilter)filter;
            if (!filter.isEnabled()) return false;
            if (!minerFilter.hasBlacklistedElement()) return false;
            return true;
        });
    }

    private void setText(GuiTextField field, PacketGuiInteract.GuiInteraction interaction) {
        if (!field.getText().isEmpty()) {
            try {
                PacketUtils.sendToServer(new PacketGuiInteract(interaction, (BlockEntity)this.tile, Integer.parseInt(field.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            field.setText("");
        }
    }

    @Override
    protected List<ItemStack> getTagStacks(String tagName) {
        return TagCache.getBlockTagStacks(tagName).stacks();
    }

    @Override
    protected List<ItemStack> getModIDStacks(String tagName) {
        return TagCache.getBlockModIDStacks(tagName).stacks();
    }
}

