/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.List;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.MekanismRecipeTypes;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class SawmillRecipe
extends MekanismRecipe<SingleRecipeInput>
implements Predicate<ItemStack> {
    protected static final RandomSource RANDOM = RandomSource.create();
    private static final Holder<Item> PRECISION_SAWMILL = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"precision_sawmill"));

    @Override
    public abstract boolean test(ItemStack var1);

    public boolean matches(SingleRecipeInput input, Level level) {
        return !this.isIncomplete() && this.test(input.item());
    }

    @Contract(value="_ -> new")
    public abstract ChanceOutput getOutput(ItemStack var1);

    public abstract List<ItemStack> getMainOutputDefinition();

    public abstract List<ItemStack> getSecondaryOutputDefinition();

    public abstract double getSecondaryChance();

    public abstract ItemStackIngredient getInput();

    @Override
    public boolean isIncomplete() {
        return this.getInput().hasNoMatchingInstances();
    }

    @Override
    public void logMissingTags() {
        this.getInput().logMissingTags();
    }

    public final RecipeType<SawmillRecipe> getType() {
        return (RecipeType)MekanismRecipeTypes.TYPE_SAWING.value();
    }

    public String getGroup() {
        return "precision_sawmill";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack(PRECISION_SAWMILL);
    }

    public static interface ChanceOutput {
        public ItemStack getMainOutput();

        public ItemStack getMaxSecondaryOutput();

        public ItemStack getSecondaryOutput();

        public ItemStack nextSecondaryOutput();
    }
}

