/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datamaps.chemical.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.datamaps.chemical.attribute.IChemicalAttribute;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ITooltipHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.ApiStatus;

public record ChemicalFuel(int burnTicks, long energyPerTick) implements IChemicalAttribute
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"chemical_attribute_fuel");
    public static final Codec<ChemicalFuel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("burn_time").forGetter(ChemicalFuel::burnTicks), (App)SerializerHelper.POSITIVE_NONZERO_LONG_CODEC.fieldOf("energy").forGetter(ChemicalFuel::energyPerTick)).apply((Applicative)instance, ChemicalFuel::new));

    public ChemicalFuel {
        if (burnTicks < 1) {
            throw new IllegalArgumentException("Fuel attributes must burn for at least one tick! Burn Ticks: " + burnTicks);
        }
        if (energyPerTick < 1L) {
            throw new IllegalArgumentException("Fuel attributes must have a per tick energy density greater than zero!");
        }
    }

    public long energyDensity() {
        return this.energyPerTick * (long)this.burnTicks;
    }

    @Override
    public void collectTooltips(Item.TooltipContext context, List<Component> tooltips, TooltipFlag tooltipFlag) {
        ITooltipHelper tooltipHelper = ITooltipHelper.INSTANCE;
        tooltips.add((Component)APILang.CHEMICAL_ATTRIBUTE_FUEL_BURN_TICKS.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getFormattedNumber(this.burnTicks)));
        tooltips.add((Component)APILang.CHEMICAL_ATTRIBUTE_FUEL_ENERGY_DENSITY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getEnergyPerMBDisplayShort(this.energyDensity())));
    }

    @Override
    @ApiStatus.Internal
    public ChemicalAttributes.Fuel toLegacyAttribute() {
        return new ChemicalAttributes.Fuel(this);
    }
}

