/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.modules.beam;

import com.clefal.nirvana_lib.relocated.io.vavr.control.Option;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.clefal.lootbeams.config.configs.LightConfig;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.data.lbitementity.rarity.LBColor;
import me.clefal.lootbeams.data.new_render.LootBeamRenderState;
import me.clefal.lootbeams.duck.PoseCopy;
import me.clefal.lootbeams.modules.beam.BeamRenderType;
import me.clefal.lootbeams.modules.dynamicprovider.DynamicProvider;
import me.clefal.lootbeams.modules.dynamicprovider.DynamicProviderModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeamRenderer {
    public static void renderLootBeam(PoseStack stack, MultiBufferSource buffer, float partialTick, LBItemEntity LBItemEntity2) {
        PoseCopy last = (PoseCopy)stack.last();
        BeamRenderer.renderLootBeam(buffer, LootBeamRenderState.BeamRenderState.fromLBEntity(LBItemEntity2, last.copy(), partialTick));
    }

    public static void renderLootBeam(MultiBufferSource buffer, LootBeamRenderState.BeamRenderState renderState) {
        LBColor color = renderState.rarity.color();
        int lifeTime = renderState.fadeIn;
        PoseStack.Pose pose = renderState.poseStack;
        PoseStack stack = new PoseStack();
        stack.last().pose().set((Matrix4fc)pose.pose());
        stack.last().normal().set((Matrix3fc)pose.normal());
        LightConfig.Beam beamConfig = LightConfig.lightConfig.beam;
        LightConfig.Glow glowConfig = LightConfig.lightConfig.glow;
        int fadeInTime = (Integer)beamConfig.beam_fade_in_time.get();
        float fadeInFactor = 1.0f * (float)lifeTime / (float)fadeInTime;
        int R = color.red();
        int G = color.green();
        int B = color.blue();
        float preBeamAlpha = ((Float)beamConfig.beam_alpha.get()).floatValue();
        LocalPlayer player = Minecraft.getInstance().player;
        double distance = Mth.sqrt((float)((float)player.distanceToSqr(renderState.location)));
        float fadeDistance = ((Float)beamConfig.beam_fade_in_distance.get()).floatValue();
        if (distance > (double)fadeDistance) {
            float m = (float)distance - fadeDistance;
            preBeamAlpha *= 1.0f / Math.max(m / fadeDistance, 1.0f);
        }
        float beamRadius = 0.05f * ((Float)beamConfig.beam_radius.get()).floatValue();
        float beamHeight = ((Float)beamConfig.beam_height.get()).floatValue();
        float yOffset = ((Float)beamConfig.beam_y_offset.get()).floatValue();
        if (beamConfig.common_shorter_beam && renderState.rarity.absoluteOrdinal() <= 0) {
            beamHeight *= 0.65f;
            yOffset -= yOffset;
        }
        int beamAlpha = (int)(preBeamAlpha * 255.0f);
        Option<DynamicProvider> dynamicProvider1 = DynamicProviderModule.getDynamicProvider();
        if (dynamicProvider1.isDefined()) {
            beamAlpha = (int)((float)beamAlpha * Math.min(((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor(), 1.0f));
            beamHeight += ((DynamicProvider)dynamicProvider1.get()).getBeamLightFactor() - 0.3f;
            beamRadius += 0.005f * ((DynamicProvider)dynamicProvider1.get()).getGlowFactor();
        }
        beamAlpha = (int)((float)beamAlpha * fadeInFactor);
        beamHeight *= fadeInFactor;
        Vector3f playerPos = player.getPosition(renderState.partialTick).toVector3f();
        Vector3f targetPos = renderState.location.toVector3f();
        Vector3f sub = targetPos.sub((Vector3fc)playerPos);
        Vector3f direction = sub.normalize();
        double v = Math.atan2(direction.x(), direction.z());
        stack.pushPose();
        stack.mulPose(Axis.YP.rotation((float)v));
        stack.pushPose();
        stack.translate(0.0f, yOffset + 1.0f, 0.0f);
        VertexConsumer buffer1 = buffer.getBuffer(BeamRenderType.LOOT_BEAM_RENDERTYPE);
        buffer1.addVertex(stack.last().pose(), -beamRadius, -beamHeight, 0.01f).setColor(R, G, B, beamAlpha).setUv(0.0f, 0.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), -beamRadius, beamHeight, 0.01f).setColor(R, G, B, 0).setUv(0.0f, 1.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), beamRadius, beamHeight, 0.01f).setColor(R, G, B, 0).setUv(1.0f, 1.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), beamRadius, -beamHeight, 0.01f).setColor(R, G, B, beamAlpha).setUv(1.0f, 0.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        float glowRadius = beamRadius * 1.35f;
        int glowAlpha = (int)((float)beamAlpha * 0.55f);
        buffer1.addVertex(stack.last().pose(), -glowRadius, -beamHeight, 0.001f).setColor(R, G, B, glowAlpha).setUv(0.0f, 0.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), -glowRadius, beamHeight, 0.001f).setColor(R, G, B, 0).setUv(0.0f, 1.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), glowRadius, beamHeight, 0.001f).setColor(R, G, B, 0).setUv(1.0f, 1.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        buffer1.addVertex(stack.last().pose(), glowRadius, -beamHeight, 0.001f).setColor(R, G, B, glowAlpha).setUv(1.0f, 0.0f).setLight(0xF000F0).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
        stack.popPose();
        stack.popPose();
        if (glowConfig.enable_glow && renderState.onGround) {
            stack.pushPose();
            stack.translate(0.0, 0.01, 0.0);
            float radius = ((Float)glowConfig.glow_effect_radius.get()).floatValue();
            BeamRenderer.renderGlow(stack, buffer.getBuffer(BeamRenderType.GLOW), R, G, B, (int)((float)beamAlpha * 0.4f), radius);
            stack.popPose();
        }
    }

    private static void renderGlow(PoseStack stack, VertexConsumer builder, int red, int green, int blue, int alpha, float radius) {
        PoseStack.Pose matrixentry = stack.last();
        Matrix4f matrixpose = matrixentry.pose();
        builder.addVertex(matrixpose, -radius, 0.0f, -radius).setColor(red, green, blue, alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrixpose, -radius, 0.0f, radius).setColor(red, green, blue, alpha).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrixpose, radius, 0.0f, radius).setColor(red, green, blue, alpha).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
        builder.addVertex(matrixpose, radius, 0.0f, -radius).setColor(red, green, blue, alpha).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrixentry, 0.0f, 1.0f, 0.0f);
    }
}

