/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.data.new_render;

import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.Event;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import me.clefal.lootbeams.LootBeamsConstants;
import me.clefal.lootbeams.config.configs.LightConfig;
import me.clefal.lootbeams.config.configs.LootInfomationConfig;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.data.lbitementity.rarity.LBRarity;
import me.clefal.lootbeams.events.TooltipsGatherNameAndRarityEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;

public abstract class LootBeamRenderState {
    public final LBRarity rarity;
    public final Vec3 location;
    public final PoseStack.Pose poseStack;

    private LootBeamRenderState(LBRarity rarity, Vec3 location, PoseStack.Pose poseStack) {
        this.rarity = rarity;
        this.location = location;
        this.poseStack = poseStack;
    }

    public static class BeamRenderState
    extends LootBeamRenderState {
        public final int fadeIn;
        public final float partialTick;
        public final boolean onGround;

        public BeamRenderState(LBRarity rarity, Vec3 location, PoseStack.Pose poseStack, int fadeIn, float partialTick, boolean onGround) {
            super(rarity, location, poseStack);
            this.fadeIn = fadeIn;
            this.partialTick = partialTick;
            this.onGround = onGround;
        }

        public static BeamRenderState fromLBEntity(LBItemEntity lbItemEntity, PoseStack.Pose stack, float partialTick) {
            ItemEntity item = lbItemEntity.item();
            BeamRenderState beamRenderState = new BeamRenderState(lbItemEntity.rarity(), new Vec3(item.getX(), item.getY(), item.getZ()), stack, lbItemEntity.fadeIn(), partialTick, lbItemEntity.item().onGround());
            if (lbItemEntity.fadeIn() < (Integer)LightConfig.lightConfig.beam.beam_fade_in_time.get()) {
                lbItemEntity.updateFade();
            }
            return beamRenderState;
        }
    }

    public static class NameTagRenderState
    extends LootBeamRenderState {
        public final List<Component> nameAndRarity;
        public final boolean isLookingAtThis;

        public NameTagRenderState(LBRarity rarity, Vec3 location, PoseStack.Pose poseStack, List<Component> nameAndRarity) {
            super(rarity, location, poseStack);
            this.nameAndRarity = nameAndRarity;
            this.isLookingAtThis = NameTagRenderState.isLookingAt(Minecraft.getInstance().player, location, ((Float)LootInfomationConfig.lootInfomationConfig.nameTag.name_tag_look_sensitivity.get()).floatValue());
        }

        public static NameTagRenderState fromLBEntity(LBItemEntity lbItemEntity, PoseStack.Pose stack) {
            ItemEntity item = lbItemEntity.item();
            TooltipsGatherNameAndRarityEvent tooltipsGatherNameAndRarityEvent = new TooltipsGatherNameAndRarityEvent(lbItemEntity);
            LootBeamsConstants.EVENT_BUS.post((Event)tooltipsGatherNameAndRarityEvent);
            ArrayList<Component> nameAndRarity = new ArrayList<Component>(tooltipsGatherNameAndRarityEvent.gather.values());
            return new NameTagRenderState(lbItemEntity.rarity(), new Vec3(item.getX(), item.getY(), item.getZ()), stack, nameAndRarity);
        }

        public static boolean isLookingAt(LocalPlayer player, Vec3 position, double accuracy) {
            Vec3 difference = new Vec3(position.x - player.getX(), position.y - player.getEyeY(), position.z - player.getZ());
            double length = difference.length();
            double dot = Minecraft.getInstance().getCameraEntity().getLookAngle().normalize().dot(difference.normalize());
            return dot > 1.0 - accuracy / length;
        }
    }
}

