/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.Element;
import snownee.jade.overlay.DisplayHelper;

public class ItemStackElement
extends Element {
    private final ItemStack item;
    private final float scale;
    private final String text;
    public static final ItemStackElement EMPTY = new ItemStackElement(ItemStack.EMPTY, 1.0f, null);

    private ItemStackElement(ItemStack item, float scale, @Nullable String text) {
        this.item = item;
        this.scale = scale == 0.0f ? 1.0f : scale;
        this.text = text;
    }

    public static ItemStackElement of(ItemStack stack) {
        return ItemStackElement.of(stack, 1.0f);
    }

    public static ItemStackElement of(ItemStack stack, float scale) {
        return ItemStackElement.of(stack, scale, null);
    }

    public static ItemStackElement of(ItemStack stack, float scale, @Nullable String text) {
        if (scale == 1.0f && stack.isEmpty()) {
            return EMPTY;
        }
        return new ItemStackElement(stack, scale, text);
    }

    @Override
    public Vec2 getSize() {
        int size = Mth.floor((float)(18.0f * this.scale));
        return new Vec2((float)size, (float)size);
    }

    @Override
    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        if (this.item.isEmpty()) {
            return;
        }
        DisplayHelper.INSTANCE.drawItem(guiGraphics, x + 1.0f, y + 1.0f, this.item, this.scale, this.text);
    }

    @Override
    @Nullable
    public String getMessage() {
        if (this.item.isEmpty()) {
            return null;
        }
        return "%s %s".formatted(this.item.getCount(), this.item.getHoverName().getString());
    }

    public ItemStack getItem() {
        return this.item;
    }
}

