/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.inventory.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.level.ItemLike;
import org.anti_ad.mc.ipnext.config.SortSettings;
import org.anti_ad.mc.ipnext.inventory.data.ItemBucket;
import org.anti_ad.mc.ipnext.item.ItemStack;
import org.anti_ad.mc.ipnext.item.ItemType;
import org.anti_ad.mc.ipnext.item.ItemTypeExtensionsKt;
import org.anti_ad.mc.ipnext.util.MutableBucket;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nItemBucket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemBucket.kt\norg/anti_ad/mc/ipnext/inventory/data/MutableItemBucket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ItemTypeExtensions.kt\norg/anti_ad/mc/ipnext/item/ItemTypeExtensionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,110:1\n1915#2,2:111\n1786#2,3:154\n1915#2,2:157\n1#3:113\n99#4,9:114\n99#4,9:133\n540#5:123\n525#5,6:124\n540#5:143\n525#5,6:144\n129#6:130\n158#6,2:131\n160#6:142\n129#6:150\n158#6,3:151\n129#6:159\n158#6,3:160\n*S KotlinDebug\n*F\n+ 1 ItemBucket.kt\norg/anti_ad/mc/ipnext/inventory/data/MutableItemBucket\n*L\n60#1:111,2\n82#1:154,3\n89#1:157,2\n68#1:114,9\n72#1:133,9\n69#1:123\n69#1:124,6\n76#1:143\n76#1:144,6\n71#1:130\n71#1:131,2\n71#1:142\n76#1:150\n76#1:151,3\n102#1:159\n102#1:160,3\n*E\n"})
public final class MutableItemBucket
extends MutableBucket
implements ItemBucket {
    private MutableItemBucket(Map map) {
        super(map);
    }

    public MutableItemBucket() {
    }

    protected final boolean validateEmpty(@NotNull ItemType itemType) {
        Intrinsics.checkNotNullParameter((Object)itemType, (String)"");
        return ItemTypeExtensionsKt.isEmpty(itemType);
    }

    public final boolean add(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"");
        return this.add(itemStack.getItemType(), itemStack.getCount());
    }

    public final void addAll(@NotNull List object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        for (ItemStack itemStack : (Iterable)object) {
            this.add(itemStack);
        }
    }

    @Override
    public final boolean contains(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"");
        return this.contains(itemStack.getItemType(), itemStack.getCount());
    }

    public final int accumulateCount(@NotNull ItemType object) {
        Map.Entry entry;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (SortSettings.INSTANCE.getTREAT_NON_STACKABLE_AS_FULL_STACKS().getBooleanValue()) {
            int n2;
            Object object2;
            ItemType itemType;
            Object v0;
            Iterator iterator = ((Iterable)this.getInnerMap().entrySet()).iterator();
            if (!iterator.hasNext()) {
                v0 = null;
            } else {
                Object object3 = iterator.next();
                if (!iterator.hasNext()) {
                    v0 = object3;
                } else {
                    itemType = (ItemType)((Map.Entry)object3).getKey();
                    ItemLike itemLike = (ItemLike)itemType.getItem();
                    PatchedDataComponentMap patchedDataComponentMap = itemType.getTag();
                    if (patchedDataComponentMap == null) {
                        DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
                        Intrinsics.checkNotNull((Object)dataComponentMap);
                        patchedDataComponentMap = (PatchedDataComponentMap)dataComponentMap;
                    }
                    int n3 = new net.minecraft.world.item.ItemStack(itemLike, 1, patchedDataComponentMap).getMaxStackSize();
                    do {
                        int n4;
                        Map.Entry entry2 = iterator.next();
                        itemType = (ItemType)((Map.Entry)entry2).getKey();
                        ItemLike itemLike2 = (ItemLike)itemType.getItem();
                        PatchedDataComponentMap patchedDataComponentMap2 = itemType.getTag();
                        if (patchedDataComponentMap2 == null) {
                            DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
                            Intrinsics.checkNotNull((Object)dataComponentMap);
                            patchedDataComponentMap2 = (PatchedDataComponentMap)dataComponentMap;
                        }
                        if (n3 >= (n4 = new net.minecraft.world.item.ItemStack(itemLike2, 1, patchedDataComponentMap2).getMaxStackSize())) continue;
                        object3 = entry2;
                        n3 = n4;
                    } while (iterator.hasNext());
                    v0 = object3;
                }
            }
            if ((object2 = (Map.Entry)v0) != null && (object2 = (ItemType)object2.getKey()) != null) {
                Object object4 = object2;
                ItemLike itemLike = (ItemLike)((ItemType)object4).getItem();
                PatchedDataComponentMap patchedDataComponentMap = ((ItemType)object4).getTag();
                if (patchedDataComponentMap == null) {
                    DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
                    Intrinsics.checkNotNull((Object)dataComponentMap);
                    patchedDataComponentMap = (PatchedDataComponentMap)dataComponentMap;
                }
                n2 = new net.minecraft.world.item.ItemStack(itemLike, 1, patchedDataComponentMap).getMaxStackSize();
            } else {
                n2 = 1;
            }
            int n5 = n2;
            Map.Entry entry3 = this.getInnerMap();
            iterator = new LinkedHashMap();
            for (Map.Entry entry2 : entry3.entrySet()) {
                entry3 = entry2;
                if (!Intrinsics.areEqual((Object)object, entry3.getKey())) continue;
                iterator.put(entry2.getKey(), entry2.getValue());
            }
            entry3 = iterator;
            iterator = new ArrayList(iterator.size());
            for (Map.Entry entry2 : entry3.entrySet()) {
                entry3 = entry2;
                object = iterator;
                itemType = (ItemType)entry3.getKey();
                ItemLike itemLike = (ItemLike)itemType.getItem();
                PatchedDataComponentMap patchedDataComponentMap = itemType.getTag();
                if (patchedDataComponentMap == null) {
                    DataComponentMap dataComponentMap = DataComponentMap.EMPTY;
                    Intrinsics.checkNotNull((Object)dataComponentMap);
                    patchedDataComponentMap = (PatchedDataComponentMap)dataComponentMap;
                }
                object.add(new net.minecraft.world.item.ItemStack(itemLike, 1, patchedDataComponentMap).getMaxStackSize() == 1 ? ((Number)entry3.getValue()).intValue() * n5 : ((Number)entry3.getValue()).intValue());
            }
            return CollectionsKt.sumOfInt((Iterable)((List)((Object)iterator)));
        }
        Map map = this.getInnerMap();
        Object object5 = new LinkedHashMap();
        for (Map.Entry entry4 : map.entrySet()) {
            entry = entry4;
            if (!Intrinsics.areEqual((Object)object, entry.getKey())) continue;
            object5.put(entry4.getKey(), entry4.getValue());
        }
        Iterator iterator = object5;
        map = iterator;
        object5 = new ArrayList(iterator.size());
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry4;
            entry = entry4 = iterator.next();
            object = object5;
            object.add(((Number)entry.getValue()).intValue());
        }
        return CollectionsKt.sumOfInt((Iterable)((List)object5));
    }

    @Override
    public final boolean containsAll(@NotNull List object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = (Iterable)object;
        if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                ItemStack itemStack = (ItemStack)object.next();
                if (this.contains(itemStack)) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean remove(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"");
        return this.remove(itemStack.getItemType(), itemStack.getCount());
    }

    public final void removeAll(@NotNull List object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        for (ItemStack itemStack : (Iterable)object) {
            this.remove(itemStack);
        }
    }

    @Override
    @NotNull
    public final ItemBucket minus(@NotNull ItemBucket itemBucket) {
        Intrinsics.checkNotNullParameter((Object)itemBucket, (String)"");
        MutableItemBucket mutableItemBucket = this.copyAsMutable();
        mutableItemBucket.removeAll(itemBucket);
        return mutableItemBucket;
    }

    @Override
    @NotNull
    public final ItemBucket copy() {
        return this.copyAsMutable();
    }

    @Override
    @NotNull
    public final MutableItemBucket copyAsMutable() {
        return new MutableItemBucket(this.getAsMap());
    }

    @NotNull
    public final String toString() {
        Object object;
        Object object2 = object = this.getAsMap();
        object = new ArrayList(object.size());
        for (Map.Entry entry : object2.entrySet()) {
            Object object3 = object;
            object3.add(ItemStack.Companion.invoke((ItemType)entry.getKey(), ((Number)entry.getValue()).intValue()));
        }
        return ((List)object).toString();
    }
}

