/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.gui;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.curios.CuriosCompat;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.item.DeepLearnerItem;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerCopySlot;

public class DeepLearnerContainer
extends PlaceboContainerMenu {
    protected final DeepLearnerSource source;
    protected final Player player;
    protected final ItemStack deepLearner;
    protected final ComponentItemHandler learnerInv;
    protected Consumer<Integer> notifyCallback;

    public DeepLearnerContainer(int id, Inventory pInv, DeepLearnerSource source) {
        super(Hostile.Containers.DEEP_LEARNER, id, pInv);
        int row;
        this.source = source;
        this.player = pInv.player;
        this.deepLearner = source.getStack(this.player);
        this.learnerInv = DeepLearnerItem.getItemHandler(this.deepLearner);
        this.addSlot((Slot)new DataModelSlot((IItemHandler)this.learnerInv, 0, 256, 99));
        this.addSlot((Slot)new DataModelSlot((IItemHandler)this.learnerInv, 1, 274, 99));
        this.addSlot((Slot)new DataModelSlot((IItemHandler)this.learnerInv, 2, 256, 117));
        this.addSlot((Slot)new DataModelSlot((IItemHandler)this.learnerInv, 3, 274, 117));
        this.playerInvStart = this.slots.size();
        for (row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int x = 89 + column * 18;
                int y = 153 + row * 18;
                int index = column + row * 9 + 9;
                Slot slot2 = new Slot((Container)this.player.getInventory(), index, x, y);
                this.addSlot(slot2);
            }
        }
        this.hotbarStart = this.slots.size();
        for (row = 0; row < 9; ++row) {
            int index = row;
            Slot slot3 = new Slot((Container)this.player.getInventory(), index, 89 + row * 18, 211);
            if (source == DeepLearnerSource.MAIN_HAND && index == this.player.getInventory().selected) {
                slot3 = new LockedSlot((Container)this.player.getInventory(), index, 89 + row * 18, 211);
            }
            this.addSlot(slot3);
        }
        this.mover.registerRule((stack, slot) -> slot < 4, 4, this.slots.size());
        this.mover.registerRule((stack, slot) -> stack.getItem() instanceof DataModelItem, 0, 4);
        this.registerInvShuffleRules();
    }

    public DeepLearnerContainer(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, DeepLearnerSource.values()[buf.readByte()]);
    }

    public void setNotifyCallback(Consumer<Integer> r) {
        this.notifyCallback = r;
    }

    public boolean stillValid(Player pPlayer) {
        return this.deepLearner.is(Hostile.Items.DEEP_LEARNER) && this.source.getStack(pPlayer) == this.deepLearner;
    }

    public boolean hasModels() {
        boolean hasModels = false;
        for (int i = 0; i < 4; ++i) {
            if (this.learnerInv.getStackInSlot(i).isEmpty()) continue;
            hasModels = true;
        }
        return hasModels;
    }

    public static enum DeepLearnerSource {
        MAIN_HAND,
        OFF_HAND,
        CURIOS;


        public ItemStack getStack(Player player) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> player.getItemInHand(InteractionHand.MAIN_HAND);
                case 1 -> player.getItemInHand(InteractionHand.OFF_HAND);
                case 2 -> CuriosCompat.getDeepLearner(player);
            };
        }

        public static DeepLearnerSource fromHand(InteractionHand hand) {
            return hand == InteractionHand.MAIN_HAND ? MAIN_HAND : OFF_HAND;
        }
    }

    public class DataModelSlot
    extends ItemHandlerCopySlot {
        public DataModelSlot(IItemHandler handler, int index, int x, int y) {
            super(handler, index, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.getItem() instanceof DataModelItem;
        }

        public int getMaxStackSize() {
            return 1;
        }

        protected void setStackCopy(ItemStack stack) {
            super.setStackCopy(stack);
            if (DeepLearnerContainer.this.notifyCallback != null) {
                DeepLearnerContainer.this.notifyCallback.accept(((Slot)this).index);
            }
        }
    }

    public static class LockedSlot
    extends Slot {
        public LockedSlot(Container inv, int index, int x, int y) {
            super(inv, index, x, y);
        }

        public boolean mayPickup(Player player) {
            return false;
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }
    }
}

