/*
 * Decompiled with CFR 0.152.
 */
package giselle.gmut.common.content.gear.mekasuit;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum VerticalSpeed implements IHasTextComponent,
IIncrementalEnum<VerticalSpeed>,
StringRepresentable
{
    OFF(1.0f),
    LOW(1.5f),
    MEDIUM(2.0f),
    HIGH(2.5f),
    ULTRA(3.0f);

    public static final Codec<VerticalSpeed> CODEC;
    public static final IntFunction<VerticalSpeed> BY_ID;
    public static final StreamCodec<ByteBuf, VerticalSpeed> STREAM_CODEC;
    private static final VerticalSpeed[] MODES;
    private final float speed;
    private final Component label;

    private VerticalSpeed(float speed) {
        this.speed = speed;
        this.label = TextComponentUtil.getString((String)Float.toString(speed));
    }

    @Nonnull
    public VerticalSpeed byIndex(int index) {
        return (VerticalSpeed)((Object)MathUtils.getByIndexMod((Object[])MODES, (int)index));
    }

    public Component getTextComponent() {
        return this.label;
    }

    public float getSpeed() {
        return this.speed;
    }

    public String getSerializedName() {
        return this.name();
    }

    static {
        CODEC = StringRepresentable.fromEnum(VerticalSpeed::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])VerticalSpeed.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        MODES = VerticalSpeed.values();
    }
}

