/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.register;

import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.api.network.WirelessType;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkData;
import sonar.fluxnetworks.common.connection.ServerFluxNetwork;
import sonar.fluxnetworks.common.data.FluxPlayerData;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.common.item.ItemAdminConfigurator;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.Channel;

@ParametersAreNonnullByDefault
public class Messages {
    static final int C2S_DEVICE_BUFFER = 0;
    static final int C2S_SUPER_ADMIN = 1;
    static final int C2S_CREATE_NETWORK = 2;
    static final int C2S_DELETE_NETWORK = 3;
    static final int C2S_EDIT_TILE = 4;
    static final int C2S_TILE_NETWORK = 5;
    static final int C2S_EDIT_ITEM = 6;
    static final int C2S_ITEM_NETWORK = 7;
    static final int C2S_EDIT_MEMBER = 8;
    static final int C2S_EDIT_NETWORK = 9;
    static final int C2S_EDIT_CONNECTION = 10;
    static final int C2S_UPDATE_NETWORK = 11;
    static final int C2S_WIRELESS_MODE = 12;
    static final int C2S_DISCONNECT = 13;
    static final int C2S_UPDATE_CONNECTIONS = 14;
    static final int C2S_TRACK_MEMBERS = 15;
    static final int C2S_TRACK_CONNECTIONS = 16;
    static final int C2S_TRACK_STATISTICS = 17;
    static final int S2C_DEVICE_BUFFER = 256;
    static final int S2C_RESPONSE = 257;
    static final int S2C_CAPABILITY = 258;
    static final int S2C_UPDATE_NETWORK = 259;
    static final int S2C_DELETE_NETWORK = 260;
    static final int S2C_UPDATE_CONNECTIONS = 261;
    static final int S2C_UPDATE_MEMBERS = 262;

    @Nonnull
    public static FriendlyByteBuf makeDeviceBuffer(TileFluxDevice device, byte type) {
        assert (type < 0);
        FriendlyByteBuf buf = Channel.buffer(256);
        buf.writeBlockPos(device.getBlockPos());
        buf.writeByte(type);
        device.writePacketBuffer(buf, type);
        return buf;
    }

    private static void response(int token, int key, int code, Player player) {
        FriendlyByteBuf buf = Channel.buffer(257);
        buf.writeByte(token);
        buf.writeShort(key);
        buf.writeByte(code);
        Channel.sChannel.sendToPlayer(buf, player);
    }

    public static void syncCapability(ServerPlayer player) {
        FriendlyByteBuf buf = Channel.buffer(258);
        FluxPlayerData fluxPlayer = FluxUtils.getPlayerData(player);
        buf.writeBoolean(FluxPlayerData.isPlayerSuperAdmin(player));
        buf.writeInt(fluxPlayer.getWirelessMode());
        buf.writeInt(fluxPlayer.getWirelessNetwork());
        Channel.sChannel.sendToPlayer(buf, player);
    }

    @Nonnull
    public static FriendlyByteBuf updateNetwork(FluxNetwork network, byte type) {
        FriendlyByteBuf buf = Channel.buffer(259);
        buf.writeByte(type);
        buf.writeVarInt(1);
        buf.writeInt(network.getNetworkID());
        CompoundTag tag = new CompoundTag();
        network.writeCustomTag(tag, type);
        buf.writeNbt((Tag)tag);
        return buf;
    }

    @Nonnull
    private static FriendlyByteBuf updateConnections(FluxNetwork network, List<CompoundTag> tags) {
        FriendlyByteBuf buf = Channel.buffer(261);
        buf.writeInt(network.getNetworkID());
        buf.writeVarInt(tags.size());
        for (CompoundTag tag : tags) {
            buf.writeNbt((Tag)tag);
        }
        return buf;
    }

    @Nonnull
    public static FriendlyByteBuf updateNetwork(Collection<FluxNetwork> networks, byte type) {
        FriendlyByteBuf buf = Channel.buffer(259);
        buf.writeByte(type);
        buf.writeVarInt(networks.size());
        for (FluxNetwork network : networks) {
            buf.writeInt(network.getNetworkID());
            CompoundTag tag = new CompoundTag();
            network.writeCustomTag(tag, type);
            buf.writeNbt((Tag)tag);
        }
        return buf;
    }

    @Nonnull
    private static FriendlyByteBuf updateNetwork(int[] networkIDs, byte type) {
        FriendlyByteBuf buf = Channel.buffer(259);
        buf.writeByte(type);
        buf.writeVarInt(networkIDs.length);
        for (int networkID : networkIDs) {
            buf.writeInt(networkID);
            CompoundTag tag = new CompoundTag();
            FluxNetworkData.getNetwork(networkID).writeCustomTag(tag, type);
            buf.writeNbt((Tag)tag);
        }
        return buf;
    }

    public static void deleteNetwork(int id) {
        FriendlyByteBuf buf = Channel.buffer(260);
        buf.writeInt(id);
        Channel.sChannel.sendToAll(buf);
    }

    static void msg(int index, FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        switch (index) {
            case 0: {
                Messages.onDeviceBuffer(payload, player, looper);
                break;
            }
            case 1: {
                Messages.onSuperAdmin(payload, player, looper);
                break;
            }
            case 2: {
                Messages.onCreateNetwork(payload, player, looper);
                break;
            }
            case 3: {
                Messages.onDeleteNetwork(payload, player, looper);
                break;
            }
            case 4: {
                Messages.onEditTile(payload, player, looper);
                break;
            }
            case 5: {
                Messages.onTileNetwork(payload, player, looper);
                break;
            }
            case 8: {
                Messages.onEditMember(payload, player, looper);
                break;
            }
            case 9: {
                Messages.onEditNetwork(payload, player, looper);
                break;
            }
            case 10: {
                Messages.onEditConnection(payload, player, looper);
                break;
            }
            case 11: {
                Messages.onUpdateNetwork(payload, player, looper);
                break;
            }
            case 12: {
                Messages.onWirelessMode(payload, player, looper);
                break;
            }
            case 13: {
                Messages.onDisconnect(payload, player, looper);
                break;
            }
            case 14: {
                Messages.onUpdateConnections(payload, player, looper);
                break;
            }
            default: {
                Messages.kick(player.get(), new RuntimeException("Unidentified message index " + index));
            }
        }
        payload.release();
    }

    private static void kick(ServerPlayer p, RuntimeException e) {
        if (p.server.isDedicatedServer()) {
            p.connection.disconnect((Component)Component.translatable((String)"multiplayer.disconnect.invalid_packet"));
            FluxNetworks.LOGGER.info("Received invalid packet from player {}", (Object)p.getGameProfile().getName(), (Object)e);
        } else {
            FluxNetworks.LOGGER.info("Received invalid packet", (Throwable)e);
        }
    }

    private static void consume(FriendlyByteBuf payload) {
        if (payload.isReadable()) {
            throw new DecoderException("Payload is not fully consumed");
        }
    }

    private static void onDeviceBuffer(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        payload.retain();
        looper.execute(() -> {
            ServerPlayer p = (ServerPlayer)player.get();
            try {
                TileFluxDevice e;
                BlockEntity patt0$temp;
                if (p != null && (patt0$temp = p.level().getBlockEntity(payload.readBlockPos())) instanceof TileFluxDevice && (e = (TileFluxDevice)patt0$temp).canPlayerAccess((Player)p)) {
                    byte id = payload.readByte();
                    if (id <= 0) {
                        throw new IllegalArgumentException();
                    }
                    e.readPacketBuffer(payload, id);
                    Messages.consume(payload);
                }
            }
            catch (RuntimeException e) {
                Messages.kick(p, e);
            }
            payload.release();
        });
    }

    private static void onSuperAdmin(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        boolean enable = payload.readBoolean();
        Messages.consume(payload);
        looper.execute(() -> {
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            FluxPlayerData fp = FluxUtils.getPlayerData(p);
            if (fp.isSuperAdmin() || FluxPlayerData.canActivateSuperAdmin(p)) {
                if (fp.setSuperAdmin(enable)) {
                    Messages.syncCapability(p);
                }
            } else {
                Messages.response(token, 0, 1, (Player)p);
            }
        });
    }

    private static void onEditTile(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        BlockPos pos = payload.readBlockPos();
        CompoundTag tag = payload.readNbt();
        Messages.consume(payload);
        Objects.requireNonNull(tag);
        looper.execute(() -> {
            boolean reject;
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            boolean bl = reject = p.containerMenu.containerId != token || !(p.containerMenu instanceof FluxMenu);
            if (reject) {
                Messages.response(token, 3, 1, (Player)p);
                return;
            }
            try {
                TileFluxDevice e;
                BlockEntity patt0$temp;
                if (p.level().isLoaded(pos) && (patt0$temp = p.level().getBlockEntity(pos)) instanceof TileFluxDevice && (e = (TileFluxDevice)patt0$temp).canPlayerAccess((Player)p)) {
                    e.readCustomTag(tag, (byte)19);
                } else {
                    Messages.response(token, 3, 1, (Player)p);
                }
            }
            catch (RuntimeException e) {
                Messages.kick(p, e);
            }
        });
    }

    private static void onCreateNetwork(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        String name = payload.readUtf(256);
        int color = payload.readInt();
        SecurityLevel security = SecurityLevel.fromId(payload.readByte());
        String password = security == SecurityLevel.ENCRYPTED ? payload.readUtf(256) : "";
        Messages.consume(payload);
        if (FluxUtils.isBadNetworkName(name)) {
            throw new IllegalArgumentException("Invalid network name: " + name);
        }
        if (security == SecurityLevel.ENCRYPTED && FluxUtils.isBadPassword(password)) {
            throw new IllegalArgumentException("Invalid network password: " + password);
        }
        looper.execute(() -> {
            boolean reject;
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            boolean bl = reject = p.containerMenu.containerId != token || !(p.containerMenu instanceof FluxMenu);
            if (reject) {
                Messages.response(token, 1, 1, (Player)p);
                return;
            }
            if (FluxNetworkData.getInstance().createNetwork(p, name, color, security, password) != null) {
                Messages.response(token, 1, -1, (Player)p);
            } else {
                Messages.response(token, 1, 4, (Player)p);
            }
        });
    }

    private static void onDeleteNetwork(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        int networkID = payload.readInt();
        Messages.consume(payload);
        looper.execute(() -> {
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            FluxNetwork network = FluxNetworkData.getNetwork(networkID);
            if (network.isValid()) {
                if (network.getPlayerAccess((Player)p).canDelete()) {
                    FluxNetworkData.getInstance().deleteNetwork(network);
                    Messages.response(token, 2, -1, (Player)p);
                } else {
                    Messages.response(token, 2, 2, (Player)p);
                }
            } else {
                Messages.response(token, 2, 1, (Player)p);
            }
        });
    }

    private static void onTileNetwork(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        BlockPos pos = payload.readBlockPos();
        int networkID = payload.readInt();
        String password = payload.readUtf(256);
        Messages.consume(payload);
        if (!password.isEmpty() && FluxUtils.isBadPassword(password)) {
            throw new IllegalArgumentException("Invalid network password: " + password);
        }
        looper.execute(() -> {
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            BlockEntity patt0$temp = p.level().getBlockEntity(pos);
            if (patt0$temp instanceof TileFluxDevice) {
                TileFluxDevice e = (TileFluxDevice)patt0$temp;
                if (e.getNetworkID() == networkID) {
                    return;
                }
                if (!e.canPlayerAccess((Player)p)) {
                    Messages.response(token, 4, 1, (Player)p);
                    return;
                }
                FluxNetwork network = FluxNetworkData.getNetwork(networkID);
                if (e.getDeviceType().isController() && network.getLogicalDevices(4).size() > 0) {
                    Messages.response(token, 4, 5, (Player)p);
                    return;
                }
                if (!network.isValid() || network.canPlayerAccess((Player)p, password)) {
                    if (network.isValid()) {
                        e.setOwnerUUID(p.getUUID());
                    }
                    e.connect(network);
                    Messages.response(token, 4, -1, (Player)p);
                    return;
                }
                if (password.isEmpty()) {
                    Messages.response(token, 4, -2, (Player)p);
                } else {
                    Messages.response(token, 4, 7, (Player)p);
                }
            } else {
                Messages.response(token, 4, 1, (Player)p);
            }
        });
    }

    private static void onEditNetwork(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        int networkID = payload.readInt();
        String name = payload.readUtf(256);
        int color = payload.readInt();
        SecurityLevel security = SecurityLevel.fromId(payload.readByte());
        String password = security == SecurityLevel.ENCRYPTED ? payload.readUtf(256) : "";
        Messages.consume(payload);
        if (FluxUtils.isBadNetworkName(name)) {
            throw new IllegalArgumentException("Invalid network name: " + name);
        }
        if (!password.isEmpty() && FluxUtils.isBadPassword(password)) {
            throw new IllegalArgumentException("Invalid network password: " + password);
        }
        looper.execute(() -> {
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            FluxNetwork network = FluxNetworkData.getNetwork(networkID);
            boolean reject = Messages.checkTokenFailed(token, p, network);
            if (reject) {
                Messages.response(token, 6, 1, (Player)p);
                return;
            }
            assert (network.isValid());
            if (network.getPlayerAccess((Player)p).canEdit()) {
                boolean changed = network.setNetworkName(name);
                if (network.setNetworkColor(color)) {
                    network.getLogicalDevices(0).forEach(TileFluxDevice::sendBlockUpdate);
                    changed = true;
                }
                changed |= network.setSecurityLevel(security);
                if (!password.isEmpty()) {
                    ((ServerFluxNetwork)network).setPassword(password);
                }
                if (changed) {
                    Channel.sChannel.sendToAll(Messages.updateNetwork(network, (byte)21));
                }
                Messages.response(token, 6, -1, (Player)p);
            } else {
                Messages.response(token, 6, 3, (Player)p);
            }
        });
    }

    private static void onUpdateNetwork(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        int size = payload.readVarInt();
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        int[] networkIDs = new int[size];
        for (int i = 0; i < size; ++i) {
            networkIDs[i] = payload.readInt();
        }
        byte type = payload.readByte();
        Messages.consume(payload);
        looper.execute(() -> {
            AbstractContainerMenu patt0$temp;
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            boolean reject = true;
            if (p.containerMenu.containerId == token && (patt0$temp = p.containerMenu) instanceof FluxMenu) {
                FluxMenu menu = (FluxMenu)patt0$temp;
                if (FluxPlayerData.isPlayerSuperAdmin(p)) {
                    reject = false;
                } else if (networkIDs.length == 1) {
                    int networkID = networkIDs[0];
                    FluxNetwork network = FluxNetworkData.getNetwork(networkID);
                    if (!(menu.mProvider instanceof ItemAdminConfigurator.Provider)) {
                        if (network.isValid() && menu.mProvider.getNetworkID() == networkID) {
                            reject = false;
                        }
                    } else if (network.isValid() && network.canPlayerAccess((Player)p)) {
                        reject = false;
                    }
                }
            }
            if (reject) {
                Messages.response(token, 8, 1, (Player)p);
            } else {
                Channel.sChannel.sendToPlayer(Messages.updateNetwork(networkIDs, type), p);
            }
        });
    }

    private static void onEditMember(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        int networkID = payload.readInt();
        UUID targetUUID = payload.readUUID();
        byte type = payload.readByte();
        Messages.consume(payload);
        looper.execute(() -> {
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            FluxNetwork network = FluxNetworkData.getNetwork(networkID);
            boolean reject = Messages.checkTokenFailed(token, p, network);
            if (reject) {
                Messages.response(token, 5, 1, (Player)p);
                return;
            }
            assert (network.isValid());
            int code = network.changeMembership((Player)p, targetUUID, type);
            if (code == -1) {
                Channel.sChannel.sendToPlayer(Messages.updateNetwork(network, (byte)22), p);
            }
            Messages.response(token, 5, code, (Player)p);
        });
    }

    private static void onEditConnection(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        int networkID = payload.readInt();
        int size = payload.readVarInt();
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<GlobalPos> list = new ArrayList<GlobalPos>(size);
        for (int i = 0; i < size; ++i) {
            list.add(FluxUtils.readGlobalPos(payload));
        }
        CompoundTag tag = payload.readNbt();
        Messages.consume(payload);
        Objects.requireNonNull(tag);
        looper.execute(() -> {
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            FluxNetwork network = FluxNetworkData.getNetwork(networkID);
            boolean reject = Messages.checkTokenFailed(token, p, network);
            if (reject) {
                Messages.response(token, 7, 1, (Player)p);
                return;
            }
            assert (network.isValid());
            if (network.getPlayerAccess((Player)p).canEdit()) {
                try {
                    for (GlobalPos pos : list) {
                        IFluxDevice f = network.getConnectionByPos(pos);
                        if (!(f instanceof TileFluxDevice)) continue;
                        TileFluxDevice e = (TileFluxDevice)f;
                        e.readCustomTag(tag, (byte)19);
                    }
                }
                catch (RuntimeException e) {
                    Messages.kick(p, e);
                    return;
                }
                Messages.response(token, 7, -1, (Player)p);
            } else {
                Messages.response(token, 7, 3, (Player)p);
            }
        });
    }

    private static boolean checkTokenFailed(int token, ServerPlayer p, FluxNetwork network) {
        AbstractContainerMenu abstractContainerMenu;
        if (!network.isValid()) {
            return true;
        }
        if (p.containerMenu.containerId == token && (abstractContainerMenu = p.containerMenu) instanceof FluxMenu) {
            FluxMenu menu = (FluxMenu)abstractContainerMenu;
            if (FluxPlayerData.isPlayerSuperAdmin(p)) {
                return false;
            }
            if (!(menu.mProvider instanceof ItemAdminConfigurator.Provider)) {
                return menu.mProvider.getNetworkID() != network.getNetworkID() && !network.canPlayerAccess((Player)p);
            }
            return !network.canPlayerAccess((Player)p);
        }
        return true;
    }

    private static void onWirelessMode(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        int wirelessMode = payload.readInt();
        int wirelessNetwork = payload.readInt();
        Messages.consume(payload);
        looper.execute(() -> {
            boolean reject;
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            FluxPlayerData fp = FluxUtils.getPlayerData(p);
            FluxNetwork network = FluxNetworkData.getNetwork(wirelessNetwork);
            boolean bl = reject = network.isValid() && (Messages.checkTokenFailed(token, p, network) || network.getMemberByUUID(p.getUUID()) == null);
            if (reject) {
                if (WirelessType.ENABLE_WIRELESS.isActivated(wirelessMode)) {
                    Messages.response(token, 0, 1, (Player)p);
                } else {
                    fp.setWirelessMode(wirelessMode);
                    Messages.syncCapability(p);
                }
            } else {
                fp.setWirelessMode(wirelessMode);
                fp.setWirelessNetwork(wirelessNetwork);
                Messages.syncCapability(p);
            }
        });
    }

    private static void onDisconnect(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        int networkID = payload.readInt();
        int size = payload.readVarInt();
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<GlobalPos> list = new ArrayList<GlobalPos>(size);
        for (int i = 0; i < size; ++i) {
            list.add(FluxUtils.readGlobalPos(payload));
        }
        Messages.consume(payload);
        looper.execute(() -> {
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            FluxNetwork network = FluxNetworkData.getNetwork(networkID);
            boolean reject = Messages.checkTokenFailed(token, p, network);
            if (reject) {
                Messages.response(token, 10, 1, (Player)p);
                return;
            }
            assert (network.isValid());
            if (network.getPlayerAccess((Player)p).canEdit()) {
                for (GlobalPos pos : list) {
                    IFluxDevice f = network.getConnectionByPos(pos);
                    if (!(f instanceof TileFluxDevice)) continue;
                    TileFluxDevice e = (TileFluxDevice)f;
                    e.disconnect();
                }
                Messages.response(token, 10, -1, (Player)p);
            } else {
                Messages.response(token, 10, 3, (Player)p);
            }
        });
    }

    private static void onUpdateConnections(FriendlyByteBuf payload, Supplier<ServerPlayer> player, BlockableEventLoop<?> looper) {
        byte token = payload.readByte();
        int networkID = payload.readInt();
        int size = payload.readVarInt();
        if (size <= 0 || size > 7) {
            throw new IllegalArgumentException();
        }
        ArrayList<GlobalPos> list = new ArrayList<GlobalPos>(size);
        for (int i = 0; i < size; ++i) {
            list.add(FluxUtils.readGlobalPos(payload));
        }
        Messages.consume(payload);
        looper.execute(() -> {
            ServerPlayer p = (ServerPlayer)player.get();
            if (p == null) {
                return;
            }
            FluxNetwork network = FluxNetworkData.getNetwork(networkID);
            boolean reject = Messages.checkTokenFailed(token, p, network);
            if (reject) {
                Messages.response(token, 9, 1, (Player)p);
                return;
            }
            assert (network.isValid());
            if (network.canPlayerAccess((Player)p)) {
                ArrayList<CompoundTag> tags = new ArrayList<CompoundTag>();
                for (GlobalPos pos : list) {
                    IFluxDevice f = network.getConnectionByPos(pos);
                    if (f == null) continue;
                    CompoundTag subTag = new CompoundTag();
                    f.writeCustomTag(subTag, (byte)20);
                    tags.add(subTag);
                }
                Channel.sChannel.sendToPlayer(Messages.updateConnections(network, tags), p);
            } else {
                Messages.response(token, 9, 1, (Player)p);
            }
        });
    }
}

