/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.util;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sonar.fluxnetworks.common.util.FluxUtils;

public final class FluxShapes {
    public static final VoxelShape FLUX_POINT_CENTRE_VOXEL = Block.box((double)5.5, (double)5.5, (double)5.5, (double)10.5, (double)10.5, (double)10.5);
    public static final VoxelShape FLUX_PLUG_CENTRE_VOXEL = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final AABB CONNECTOR_CABLE_BB_SHAPE = new AABB(0.4375, 0.0625, 0.4375, 0.5625, 0.375, 0.5625);
    public static final AABB CONNECTOR_PLATE_BB_SHAPE = new AABB(0.3125, 0.0, 0.3125, 0.6875, 0.0625, 0.6875);
    public static final VoxelShape[] CONNECTORS_ROTATED_VOXELS = (VoxelShape[])Arrays.stream(FluxUtils.DIRECTIONS).map(dir -> Shapes.or((VoxelShape)FluxShapes.rotate(CONNECTOR_CABLE_BB_SHAPE, dir), (VoxelShape)FluxShapes.rotate(CONNECTOR_PLATE_BB_SHAPE, dir))).toArray(VoxelShape[]::new);
    public static final VoxelShape FLUX_CONTROLLER_VOXEL = Shapes.or((VoxelShape)Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0), Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0), Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0)});

    @Nonnull
    public static VoxelShape rotate(@Nonnull AABB aabb, @Nonnull Direction dir) {
        return Shapes.create((AABB)FluxShapes.rotateToDirection(aabb.move(-0.5, -0.5, -0.5), dir).move(0.5, 0.5, 0.5));
    }

    @Nonnull
    public static AABB rotateToDirection(@Nonnull AABB aabb, @Nonnull Direction dir) {
        return switch (dir) {
            case Direction.UP -> new AABB(aabb.minX, -aabb.minY, -aabb.minZ, aabb.maxX, -aabb.maxY, -aabb.maxZ);
            case Direction.NORTH -> new AABB(aabb.minX, -aabb.minZ, aabb.minY, aabb.maxX, -aabb.maxZ, aabb.maxY);
            case Direction.SOUTH -> new AABB(-aabb.minX, aabb.minZ, -aabb.minY, -aabb.maxX, aabb.maxZ, -aabb.maxY);
            case Direction.WEST -> new AABB(aabb.minY, -aabb.minZ, -aabb.minX, aabb.maxY, -aabb.maxZ, -aabb.maxX);
            case Direction.EAST -> new AABB(-aabb.minY, aabb.minZ, aabb.minX, -aabb.maxY, aabb.maxZ, aabb.maxX);
            default -> aabb;
        };
    }

    private FluxShapes() {
    }
}

