/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import sonar.fluxnetworks.api.device.IFluxController;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.device.IFluxPlug;
import sonar.fluxnetworks.api.device.IFluxPoint;
import sonar.fluxnetworks.api.device.IFluxStorage;
import sonar.fluxnetworks.api.network.AccessLevel;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.SecurityLevel;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.PhantomFluxDevice;
import sonar.fluxnetworks.common.connection.TransferHandler;
import sonar.fluxnetworks.common.connection.TransferIterator;
import sonar.fluxnetworks.common.data.FluxPlayerData;
import sonar.fluxnetworks.common.device.TileFluxDevice;

public class ServerFluxNetwork
extends FluxNetwork {
    private static final Comparator<TileFluxDevice> sDescendingOrder = (lhs, rhs) -> Integer.compare(rhs.getTransferHandler().getPriority(), lhs.getTransferHandler().getPriority());
    private static final Class<?>[] sLogicalTypes = new Class[]{IFluxDevice.class, IFluxPlug.class, IFluxPoint.class, IFluxStorage.class, IFluxController.class};
    private final ArrayList<TileFluxDevice>[] mDevices;
    private final LinkedList<TileFluxDevice> mToAdd = new LinkedList();
    private final LinkedList<TileFluxDevice> mToRemove = new LinkedList();
    private boolean mSortConnections = true;
    private final TransferIterator mPlugTransferIterator = new TransferIterator(false);
    private final TransferIterator mPointTransferIterator = new TransferIterator(true);
    private long mBufferLimiter = 0L;
    private String mPassword;

    ServerFluxNetwork() {
        ArrayList[] devices = (ArrayList[])Array.newInstance(ArrayList.class, sLogicalTypes.length);
        Arrays.setAll(devices, type -> new ArrayList());
        this.mDevices = devices;
    }

    ServerFluxNetwork(int id, String name, int color, @Nonnull SecurityLevel security, @Nonnull Player owner, @Nonnull String password) {
        super(id, name, color, security, owner);
        ArrayList[] devices = (ArrayList[])Array.newInstance(ArrayList.class, sLogicalTypes.length);
        Arrays.setAll(devices, type -> new ArrayList());
        this.mDevices = devices;
        this.mPassword = password;
    }

    private void handleConnectionQueue() {
        List list;
        int type;
        TileFluxDevice device;
        while ((device = this.mToAdd.poll()) != null) {
            for (type = 0; type < sLogicalTypes.length; ++type) {
                if (!sLogicalTypes[type].isInstance(device)) continue;
                list = this.getLogicalDevices(type);
                assert (!((ArrayList)list).contains(device));
                this.mSortConnections |= ((ArrayList)list).add(device);
            }
        }
        while ((device = this.mToRemove.poll()) != null) {
            for (type = 0; type < sLogicalTypes.length; ++type) {
                if (!sLogicalTypes[type].isInstance(device)) continue;
                list = this.getLogicalDevices(type);
                assert (((ArrayList)list).contains(device));
                this.mSortConnections |= ((ArrayList)list).remove(device);
            }
        }
        if (this.mSortConnections) {
            ((ArrayList)this.getLogicalDevices(1)).sort(sDescendingOrder);
            ((ArrayList)this.getLogicalDevices(2)).sort(sDescendingOrder);
            this.mSortConnections = false;
        }
    }

    @Nonnull
    public ArrayList<TileFluxDevice> getLogicalDevices(int logic) {
        return this.mDevices[logic];
    }

    @Override
    public void onEndServerTick() {
        this.mStatistics.startProfiling();
        this.handleConnectionQueue();
        this.mBufferLimiter = 0L;
        List devices = this.getLogicalDevices(0);
        for (TileFluxDevice d : devices) {
            d.getTransferHandler().onCycleStart();
        }
        List plugs = this.getLogicalDevices(1);
        List points = this.getLogicalDevices(2);
        if (!points.isEmpty() && !plugs.isEmpty()) {
            TransferIterator plugIterator = this.mPlugTransferIterator.reset(plugs);
            TransferIterator pointIterator = this.mPointTransferIterator.reset(points);
            block1: while (pointIterator.hasNext()) {
                while (plugIterator.hasNext()) {
                    TileFluxDevice plug = plugIterator.next();
                    TileFluxDevice point = pointIterator.next();
                    if (plug.getDeviceType() == point.getDeviceType()) break block1;
                    long actual = plug.getTransferHandler().removeFromBuffer(point.getTransferHandler().getRequest());
                    if (actual > 0L) {
                        point.getTransferHandler().addToBuffer(actual);
                        continue block1;
                    }
                    plugIterator.increment();
                }
                break block1;
            }
        }
        long limiter = 0L;
        for (TileFluxDevice d : devices) {
            TransferHandler h = d.getTransferHandler();
            h.onCycleEnd();
            limiter += h.getRequest();
            if (h.getChange() == 0L) continue;
            d.markEnergyChanged();
        }
        this.mBufferLimiter = limiter;
        this.mStatistics.stopProfiling();
    }

    @Override
    public long getBufferLimiter() {
        return this.mBufferLimiter;
    }

    @Override
    @Nonnull
    public AccessLevel getPlayerAccess(@Nonnull Player player) {
        if (FluxPlayerData.isPlayerSuperAdmin((ServerPlayer)player)) {
            return AccessLevel.SUPER_ADMIN;
        }
        return super.getPlayerAccess(player);
    }

    @Override
    public boolean canPlayerAccess(@Nonnull Player player, @Nonnull String password) {
        if (super.canPlayerAccess(player, password)) {
            return true;
        }
        return !password.isEmpty() && password.equals(this.mPassword);
    }

    @Override
    public void onDelete() {
        super.onDelete();
        ((ArrayList)this.getLogicalDevices(0)).forEach(TileFluxDevice::disconnect);
        Arrays.fill(this.mDevices, null);
        this.mToAdd.clear();
        this.mToRemove.clear();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean enqueueConnectionAddition(@Nonnull TileFluxDevice device) {
        if (device.getDeviceType().isController() && !((ArrayList)this.getLogicalDevices(4)).isEmpty()) {
            return false;
        }
        if (!this.mToAdd.contains(device) && !((ArrayList)this.getLogicalDevices(0)).contains(device)) {
            this.mToAdd.offer(device);
            this.mToRemove.remove(device);
            this.mConnectionMap.put(device.getGlobalPos(), device);
            return true;
        }
        return false;
    }

    @Override
    public void enqueueConnectionRemoval(@Nonnull TileFluxDevice device, boolean unload) {
        if (!this.mToRemove.contains(device) && ((ArrayList)this.getLogicalDevices(0)).contains(device)) {
            this.mToRemove.offer(device);
            this.mToAdd.remove(device);
            if (unload) {
                this.mConnectionMap.put(device.getGlobalPos(), PhantomFluxDevice.makeUnloaded(device));
            } else {
                this.mConnectionMap.remove(device.getGlobalPos());
            }
        }
    }

    public void setPassword(@Nonnull String password) {
        this.mPassword = password;
    }

    public void markSortConnections() {
        this.mSortConnections = true;
    }

    @Override
    public int changeMembership(@Nonnull Player player, @Nonnull UUID targetUUID, byte type) {
        AccessLevel access = this.getPlayerAccess(player);
        boolean editPermission = access.canEdit();
        boolean ownerPermission = access.canDelete();
        if (!editPermission) {
            return 3;
        }
        boolean self = player.getUUID().equals(targetUUID);
        NetworkMember current = this.getMemberByUUID(targetUUID);
        if (type == 1 && current == null) {
            ServerPlayer target = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(targetUUID);
            if (target != null) {
                NetworkMember m = NetworkMember.create((Player)target, AccessLevel.USER);
                this.mMemberMap.put(m.getPlayerUUID(), m);
                return -1;
            }
            return 6;
        }
        if (current != null) {
            if (self && current.getAccessLevel() == AccessLevel.OWNER) {
                return 6;
            }
            boolean changed = false;
            if (type == 2) {
                if (!ownerPermission) {
                    return 2;
                }
                changed = current.setAccessLevel(AccessLevel.ADMIN);
            } else if (type == 1) {
                changed = current.setAccessLevel(AccessLevel.USER);
            } else if (type == 3) {
                changed = this.mMemberMap.remove(targetUUID) != null;
            } else if (type == 4) {
                if (!ownerPermission) {
                    return 2;
                }
                this.getAllMembers().forEach(f -> {
                    if (f.getAccessLevel().canDelete()) {
                        f.setAccessLevel(AccessLevel.USER);
                    }
                });
                this.mOwnerUUID = targetUUID;
                current.setAccessLevel(AccessLevel.OWNER);
                changed = true;
            }
            return changed ? -1 : 6;
        }
        if (type == 4) {
            if (!ownerPermission) {
                return 2;
            }
            if (self && access == AccessLevel.OWNER) {
                return 6;
            }
            ServerPlayer target = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(targetUUID);
            if (target != null) {
                this.getAllMembers().forEach(f -> {
                    if (f.getAccessLevel().canDelete()) {
                        f.setAccessLevel(AccessLevel.USER);
                    }
                });
                NetworkMember m = NetworkMember.create((Player)target, AccessLevel.OWNER);
                this.mMemberMap.put(m.getPlayerUUID(), m);
                this.mOwnerUUID = targetUUID;
                return -1;
            }
            return 6;
        }
        return 6;
    }

    @Override
    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        super.writeCustomTag(tag, type);
        if (type == 1) {
            tag.putString("password", this.mPassword);
        }
    }

    @Override
    public void readCustomTag(@Nonnull CompoundTag tag, byte type) {
        super.readCustomTag(tag, type);
        this.mPassword = tag.getString("password");
    }
}

