/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.util;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MessageUtil {
    private MessageUtil() {
    }

    public static Component createEnhancedHighlightMessage(Player player, BlockPos targetPos, ResourceKey<Level> targetDimension, String translatable) {
        String dimensionId = targetDimension.location().toString();
        int distance = (int)Math.sqrt(player.blockPosition().distSqr((Vec3i)targetPos));
        String tpCommand = "/tp @s " + targetPos.getX() + " " + targetPos.getY() + " " + targetPos.getZ();
        MutableComponent coordsComponent = Component.literal((String)("[" + targetPos.toShortString() + "]")).withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, tpCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"))));
        String dimTpCommand = "/execute in " + dimensionId + " run tp @s " + targetPos.getX() + " " + targetPos.getY() + " " + targetPos.getZ();
        MutableComponent dimensionComponent = Component.literal((String)dimensionId).withStyle(style -> style.withColor(ChatFormatting.AQUA).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, dimTpCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"))));
        return Component.translatable((String)translatable, (Object[])new Object[]{coordsComponent, dimensionComponent, distance});
    }
}

