/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.container.pattern.ContainerPattern;
import com.glodblock.github.extendedae.container.pattern.PatternGuiHandler;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ContainerProcessingPattern
extends ContainerPattern {
    public static final ResourceLocation ID = ExtendedAE.id("proc_pattern");
    public static final MenuType<ContainerProcessingPattern> TYPE = PatternGuiHandler.register(ID, ContainerProcessingPattern::new);

    public ContainerProcessingPattern(@Nullable MenuType<?> menuType, int id, Level world, ItemStack stack) {
        super(menuType, world, id, stack);
        int col;
        int row;
        for (row = 0; row < 9; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new ContainerPattern.DisplayOnlySlot(this, this.inputs, row * 9 + col, 8 + col * 18, 9 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new ContainerPattern.DisplayOnlySlot(this, this.outputs, row * 9 + col, 8 + col * 18, 189 + row * 18));
            }
        }
    }

    @Override
    protected void analyse() {
        IPatternDetails iPatternDetails = this.details;
        if (iPatternDetails instanceof AEProcessingPattern) {
            AEProcessingPattern pattern = (AEProcessingPattern)iPatternDetails;
            this.addContents(pattern.getSparseInputs(), this.inputs);
            this.addContents(pattern.getSparseOutputs(), this.outputs);
        } else {
            this.invalidate();
        }
    }

    protected void addContents(List<GenericStack> stacks, List<GenericStack[]> slots) {
        for (GenericStack stack : stacks) {
            if (stack == null) {
                slots.add(new GenericStack[0]);
                continue;
            }
            GenericStack[] outStacks = new GenericStack[]{new GenericStack(stack.what(), stack.amount())};
            slots.add(outStacks);
        }
    }
}

