/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.core.localization.Tooltips;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.OutputSlot;
import appeng.util.ConfigMenuInventory;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.common.tileentities.TileCrystalAssembler;
import com.glodblock.github.extendedae.container.helper.DirectionSet;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class ContainerCrystalAssembler
extends UpgradeableMenu<TileCrystalAssembler>
implements IProgressProvider,
IActionHolder {
    @GuiSync(value=3)
    public int processingTime = -1;
    @GuiSync(value=8)
    public YesNo autoExport = YesNo.NO;
    @GuiSync(value=9)
    public DirectionSet outputSides = new DirectionSet(new ArrayList<Direction>());
    private final ActionMap actions = ActionMap.create();
    private final AppEngSlot tank;
    public static final MenuType<ContainerCrystalAssembler> TYPE = MenuTypeBuilder.create(ContainerCrystalAssembler::new, TileCrystalAssembler.class).buildUnregistered(ExtendedAE.id("crystal_assembler"));

    public ContainerCrystalAssembler(int id, Inventory ip, TileCrystalAssembler host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        for (int x = 0; x < 9; ++x) {
            this.addSlot((Slot)new AppEngSlot((InternalInventory)host.getInput(), x), SlotSemantics.MACHINE_INPUT);
        }
        this.tank = new AppEngSlot((InternalInventory)new ConfigMenuInventory(host.getTank()), 0);
        this.addSlot((Slot)this.tank, SlotSemantics.STORAGE);
        this.addSlot((Slot)new OutputSlot((InternalInventory)host.getOutput(), 0, null), SlotSemantics.MACHINE_OUTPUT);
        this.tank.setEmptyTooltip(() -> List.of(Component.translatable((String)"gui.extendedae.crystal_assembler.tank_empty"), Component.translatable((String)"gui.extendedae.crystal_assembler.amount", (Object[])new Object[]{0, 16000}).withStyle(Tooltips.NORMAL_TOOLTIP_TEXT)));
        this.actions.put("set_side", o -> this.setOutputSide((String)o.get(0), (Boolean)o.get(1)));
    }

    private void setOutputSide(String name, boolean value) {
        Direction side = Direction.byName((String)name);
        if (value) {
            ((TileCrystalAssembler)this.getHost()).getOutputSides().add(side);
        } else {
            ((TileCrystalAssembler)this.getHost()).getOutputSides().remove(side);
        }
    }

    public boolean isTank(Slot slot) {
        return slot == this.tank;
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.autoExport = (YesNo)cm.getSetting(Settings.AUTO_EXPORT);
        this.outputSides.clear();
        this.outputSides.addAll(((TileCrystalAssembler)this.getHost()).getOutputSides());
    }

    protected void standardDetectAndSendChanges() {
        if (this.isServerSide()) {
            this.processingTime = ((TileCrystalAssembler)this.getHost()).getProgress();
        }
        super.standardDetectAndSendChanges();
    }

    public int getCurrentProgress() {
        return this.processingTime;
    }

    public int getMaxProgress() {
        return 200;
    }

    public YesNo getAutoExport() {
        return this.autoExport;
    }

    public List<Direction> getOutputSides() {
        return this.outputSides.sides();
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }
}

