/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.button;

import appeng.client.gui.Icon;
import appeng.client.gui.style.Blitter;
import com.glodblock.github.extendedae.client.button.EPPButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class OutputButton
extends EPPButton {
    private static final Component tooltipOn = Component.translatable((String)"gui.extendedae.set_output_sides.on");
    private static final Component tooltipOff = Component.translatable((String)"gui.extendedae.set_output_sides.off");
    private ItemStack display = ItemStack.EMPTY;
    private boolean isOn = false;

    public OutputButton(Button.OnPress onPress) {
        super(onPress);
    }

    public void setDisplay(ItemLike stack) {
        this.display = new ItemStack(stack);
    }

    public void setOn(boolean value) {
        this.isOn = value;
    }

    public boolean isOn() {
        return this.isOn;
    }

    public void flip() {
        this.isOn ^= true;
    }

    @NotNull
    public Component getMessage() {
        return this.isOn ? tooltipOn : tooltipOff;
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            int yOffset;
            int n = yOffset = this.isHovered() ? 1 : 0;
            Icon bgIcon = this.isHovered() ? Icon.TOOLBAR_BUTTON_BACKGROUND_HOVER : (this.isOn() ? Icon.TOOLBAR_BUTTON_BACKGROUND_FOCUS : Icon.TOOLBAR_BUTTON_BACKGROUND);
            bgIcon.getBlitter().dest(this.getX() - 1, this.getY() + yOffset, 18, 20).zOffset(2).blit(guiGraphics);
            if (!this.display.isEmpty()) {
                guiGraphics.renderItem(this.display, this.getX(), this.getY() + 1 + yOffset, 0, 3);
            }
        }
    }

    public Item getItemOverlay() {
        return this.display.getItem();
    }

    @Override
    Blitter getBlitterIcon() {
        return null;
    }
}

