/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.networking.IGridNode;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.menu.guisync.GuiSync;
import appeng.menu.guisync.PacketWritable;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.common.me.wireless.WirelessStatus;
import com.glodblock.github.extendedae.common.tileentities.TileWirelessHub;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ContainerWirelessHub
extends UpgradeableMenu<TileWirelessHub>
implements IActionHolder {
    public static final MenuType<ContainerWirelessHub> TYPE = MenuTypeBuilder.create(ContainerWirelessHub::new, TileWirelessHub.class).buildUnregistered(ExtendedAE.id("wireless_hub"));
    @GuiSync(value=7)
    public double powerUse;
    @GuiSync(value=8)
    public int usedChannel;
    @GuiSync(value=9)
    public int maxChannel;
    @GuiSync(value=10)
    public PortStatus status = new PortStatus();
    private final ActionMap actions = ActionMap.create();

    public ContainerWirelessHub(int id, Inventory ip, TileWirelessHub host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        this.actions.put("disconnect", o -> this.disconnect((Integer)o.get(0)));
    }

    private void disconnect(int port) {
        ((TileWirelessHub)this.getHost()).killPort(port);
    }

    public WirelessStatus getStatus(int port) {
        return this.status.getStatus((int)port).status;
    }

    public BlockPos getRemotePosition(int port) {
        return BlockPos.of((long)this.status.getStatus((int)port).pos);
    }

    public int getRemoteChannel(int port) {
        return this.status.getStatus((int)port).channel;
    }

    public void broadcastChanges() {
        this.powerUse = ((TileWirelessHub)this.getHost()).getPowerUse();
        IGridNode node = ((TileWirelessHub)this.getHost()).getMainNode().getNode();
        if (node != null) {
            this.usedChannel = node.getUsedChannels();
            this.maxChannel = node.getMaxChannels();
        } else {
            this.usedChannel = 0;
            this.maxChannel = 0;
        }
        PortStatus hostStatus = new PortStatus();
        for (int i = 0; i < 8; ++i) {
            BlockPos otherSide = ((TileWirelessHub)this.getHost()).getOtherSide(i);
            WirelessStatus localStatus = this.status.getStatus((int)i).status;
            int localChannel = this.status.getStatus((int)i).channel;
            long localPos = this.status.getStatus((int)i).pos;
            if (otherSide == null) {
                localPos = 0L;
                localChannel = 0;
                localStatus = ((TileWirelessHub)this.getHost()).getFrequency(i) == 0L ? WirelessStatus.UNCONNECTED : WirelessStatus.REMOTE_ERROR;
            } else {
                IGridConnectedBlockEntity gridHost;
                IGridNode remoteNode;
                BlockEntity remote = ((TileWirelessHub)this.getHost()).getLevel().getBlockEntity(otherSide);
                if (remote instanceof IGridConnectedBlockEntity && (remoteNode = (gridHost = (IGridConnectedBlockEntity)remote).getMainNode().getNode()) != null) {
                    localChannel = remoteNode.getUsedChannels();
                }
                localPos = otherSide.asLong();
                localStatus = WirelessStatus.WORKING;
            }
            if (!((TileWirelessHub)this.getHost()).getMainNode().isPowered() && localStatus == WirelessStatus.WORKING) {
                localStatus = WirelessStatus.NO_POWER;
            }
            hostStatus.setStatus(i, new PortStatus.Status(localPos, localChannel, localStatus));
        }
        this.status = hostStatus;
        super.broadcastChanges();
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }

    public record PortStatus(Status[] statuses) implements PacketWritable
    {
        public PortStatus() {
            this(new Status[8]);
            Arrays.fill(this.statuses, new Status(0L, 0, WirelessStatus.UNCONNECTED));
        }

        public PortStatus(RegistryFriendlyByteBuf data) {
            this(new Status[8]);
            for (int i = 0; i < 8; ++i) {
                this.statuses[i] = Status.readFromPacket(data);
            }
        }

        private Status getStatus(int port) {
            return this.statuses[port];
        }

        private void setStatus(int port, Status status) {
            this.statuses[port] = status;
        }

        public void writeToPacket(RegistryFriendlyByteBuf data) {
            for (int i = 0; i < 8; ++i) {
                this.statuses[i].writeToPacket(data);
            }
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.statuses);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            Object[] that;
            if (o == this) {
                return true;
            }
            if (!(o instanceof PortStatus)) return false;
            PortStatus portStatus = (PortStatus)o;
            try {
                Object[] objectArray;
                that = objectArray = portStatus.statuses();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return Arrays.equals(this.statuses, that);
        }

        private record Status(long pos, int channel, WirelessStatus status) implements PacketWritable
        {
            static Status readFromPacket(RegistryFriendlyByteBuf data) {
                return new Status(data.readLong(), data.readInt(), (WirelessStatus)data.readEnum(WirelessStatus.class));
            }

            public void writeToPacket(RegistryFriendlyByteBuf data) {
                data.writeLong(this.pos);
                data.writeInt(this.channel);
                data.writeEnum((Enum)this.status);
            }
        }
    }
}

