/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import appeng.core.definitions.AEItems;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.me.wireless.WirelessConnect;
import com.glodblock.github.extendedae.common.me.wireless.WirelessNode;
import com.glodblock.github.extendedae.config.EAEConfig;
import com.glodblock.github.extendedae.util.CacheHolder;
import com.glodblock.github.extendedae.xmod.jade.JadeDataProvider;
import com.glodblock.github.glodium.util.GlodUtil;
import gripe._90.megacells.definition.MEGAItems;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileWirelessHub
extends AENetworkedBlockEntity
implements ServerTickingBlockEntity,
IUpgradeableObject,
IColorableBlockEntity,
JadeDataProvider {
    public static final int MAX_PORT = 8;
    private final boolean[] updateStatus = new boolean[8];
    private final long[] freq = new long[8];
    private final WirelessConnect[] connect = new WirelessConnect[8];
    private double powerUse;
    private final IUpgradeInventory upgrades;
    private final CacheHolder<BlockPos>[] other = new CacheHolder[8];
    @NotNull
    private AEColor color = AEColor.TRANSPARENT;

    public TileWirelessHub(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileWirelessHub.class, TileWirelessHub::new, (Block)EAESingletons.WIRELESS_HUB), pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.allOf(Direction.class));
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.DENSE_CAPACITY});
        this.powerUse = 1.0;
        this.getMainNode().setIdlePowerUsage(this.powerUse);
        this.upgrades = UpgradeInventories.forMachine((ItemLike)EAESingletons.WIRELESS_HUB, (int)4, this::updatePowerUsage);
        for (int i = 0; i < 8; ++i) {
            this.updateStatus[i] = true;
            this.connect[i] = new WirelessConnect(new Stock(this, i));
            this.other[i] = CacheHolder.empty();
        }
    }

    public int allocatePort() {
        for (int i = 0; i < 8; ++i) {
            if (this.connect[i].isConnected()) continue;
            return i;
        }
        return -1;
    }

    public void killPort(int port) {
        this.freq[port] = 0L;
        this.connect[port].destroy();
        this.connect[port] = new WirelessConnect(new Stock(this, port));
        this.updateStatus[port] = true;
        this.setChanged();
    }

    public long getFrequency(int port) {
        return this.freq[port];
    }

    public void serverTick() {
        boolean changed = false;
        for (int i = 0; i < 8; ++i) {
            if (!this.updateStatus[i]) continue;
            this.updateStatus[i] = false;
            this.other[i].expired();
            this.connect[i].updateStatus();
            this.reactive(i);
            changed = true;
        }
        if (changed) {
            this.updatePowerUsage();
            this.markForUpdate();
        }
    }

    public void updatePowerUsage() {
        double disc = 1.0 - this.calculateDisc();
        this.powerUse = 0.0;
        boolean anyRunning = false;
        for (int i = 0; i < 8; ++i) {
            if (!this.connect[i].isConnected()) continue;
            double dis = Math.max(this.connect[i].getDistance(), Math.E);
            this.powerUse += Math.max(1.0, dis * Math.log(dis) * disc) * EAEConfig.wirelessPowerMultiplier;
            anyRunning = true;
        }
        if (!anyRunning) {
            this.powerUse = EAEConfig.wirelessPowerMultiplier;
        }
        this.getMainNode().setIdlePowerUsage(this.powerUse);
    }

    private double calculateDisc() {
        double disc = 0.1 * (double)this.upgrades.getInstalledUpgrades((ItemLike)AEItems.ENERGY_CARD);
        if (GlodUtil.checkMod((String)"megacells")) {
            disc += 0.2 * (double)this.upgrades.getInstalledUpgrades((ItemLike)MEGAItems.GREATER_ENERGY_CARD);
        }
        return disc;
    }

    public double getPowerUse() {
        return this.powerUse;
    }

    @Nullable
    public BlockPos getOtherSide(int port) {
        if (this.connect[port].isConnected()) {
            if (!this.other[port].isValid()) {
                this.other[port].update(this.connect[port].getOtherSide());
            }
            return this.other[port].get();
        }
        return null;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        Arrays.fill(this.updateStatus, true);
    }

    public void reactive(int port) {
        this.connect[port].active();
    }

    public void onChunkUnloaded() {
        this.disconnectAll();
        super.onChunkUnloaded();
    }

    public void onReady() {
        super.onReady();
        Arrays.fill(this.updateStatus, true);
    }

    public void setRemoved() {
        this.disconnectAll();
        super.setRemoved();
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.upgrades.readFromNBT(data, "upgrades", registries);
        if (data.contains("freq")) {
            this.freq[0] = data.getLong("freq");
            WirelessConnect.G.markUsed(this.freq[0]);
        } else {
            for (int i = 0; i < 8; ++i) {
                this.freq[i] = data.getLong("freq" + i);
                WirelessConnect.G.markUsed(this.freq[i]);
            }
        }
        this.color = data.contains("color") ? AEColor.valueOf((String)data.getString("color")) : AEColor.TRANSPARENT;
        this.getMainNode().setGridColor(this.color);
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        this.upgrades.writeToNBT(data, "upgrades", registries);
        for (int i = 0; i < 8; ++i) {
            data.putLong("freq" + i, this.freq[i]);
            WirelessConnect.G.markUsed(this.freq[i]);
        }
        data.putString("color", this.color.name());
    }

    public void setFrequency(long freq, int port) {
        this.freq[port] = freq;
        this.updateStatus[port] = true;
        this.setChanged();
    }

    public long getNewFreq() {
        return WirelessConnect.G.genFreq();
    }

    public void disconnectAll() {
        for (int i = 0; i < 8; ++i) {
            this.connect[i].destroy();
        }
    }

    public boolean isConnected() {
        for (int i = 0; i < 8; ++i) {
            if (!this.connect[i].isConnected()) continue;
            return true;
        }
        return false;
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.DENSE_SMART;
    }

    public void breakOnRemove() {
        for (int i = 0; i < 8; ++i) {
            this.connect[i].destroy();
        }
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack card : this.upgrades) {
            drops.add(card);
        }
    }

    public void clearContent() {
        super.clearContent();
        this.upgrades.clear();
    }

    @NotNull
    public AEColor getColor() {
        return this.color;
    }

    public boolean recolourBlock(Direction side, AEColor colour, Player who) {
        if (colour == this.color) {
            return false;
        }
        this.color = colour;
        this.saveChanges();
        this.markForUpdate();
        this.getMainNode().setGridColor(this.color);
        return true;
    }

    @Override
    public String jadeID() {
        return "wireless";
    }

    @Override
    public void collectJadeInfo(CompoundTag tag) {
        tag.putString("color", this.color.name());
        this.getMainNode().ifPresent((gird, node) -> tag.putInt("used", node.getUsedChannels()));
    }

    private record Stock(TileWirelessHub hub, int port) implements WirelessNode
    {
        @Override
        public long getFrequency() {
            return this.hub.freq[this.port];
        }

        @Override
        public Level getLevel() {
            return this.hub.getLevel();
        }

        @Override
        public BlockPos getBlockPos() {
            return this.hub.getBlockPos();
        }

        @Override
        public IGridNode getGridNode() {
            return this.hub.getGridNode();
        }

        @Override
        public BlockEntity getBlockEntity() {
            return this.hub;
        }
    }
}

