/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.util;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.config.Config;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.HashUtils;
import com.euphoriapatches.shadow.com.google.gson.Gson;
import com.euphoriapatches.shadow.com.google.gson.GsonBuilder;
import com.euphoriapatches.shadow.com.google.gson.JsonElement;
import com.euphoriapatches.shadow.com.google.gson.JsonObject;
import com.euphoriapatches.shadow.com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;

public class ShaderData {
    private static final Path DATA_FILE = Config.CONFIG_DIR.resolve("data.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static PersistentShaderData cachedData = null;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderData] " + message);
    }

    public static void validateShaderDataHash() {
        ShaderData.debugLog("Validating shaderpacks directory hash");
        String currentShadersDir = EuphoriaPatcher.shaderpacks.toString();
        ShaderData.debugLog("Current shaderpacks directory: " + currentShadersDir);
        String currentShaderHash = HashUtils.calculateSHA256(currentShadersDir);
        if (currentShaderHash == null) {
            ShaderData.debugLog("Failed to calculate hash for current shaderpacks directory");
            return;
        }
        ShaderData.debugLog("Current shaderpacks directory hash: " + currentShaderHash);
        if (!ShaderData.dataFileExists()) {
            ShaderData.debugLog("Data file does not exist, will create with current shaderpacks hash");
            ShaderData.save(SaveData.of(DataField.SHADER_HASH, currentShaderHash));
            return;
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(DATA_FILE, new OpenOption[0]), StandardCharsets.UTF_8);){
            PersistentShaderData data = GSON.fromJson((Reader)reader, PersistentShaderData.class);
            if (data == null || data.shaderHash == null) {
                ShaderData.debugLog("No shaderpacks hash stored in data file, will save current one");
                ShaderData.save(SaveData.of(DataField.SHADER_HASH, currentShaderHash));
                return;
            }
            if (!data.shaderHash.equals(currentShaderHash)) {
                ShaderData.debugLog("Shaderpacks hash mismatch! Stored: " + data.shaderHash + ", Current: " + currentShaderHash);
                ShaderData.debugLog("Deleting data file to ensure user-specific data");
                ShaderData.deleteDataFile();
                ShaderData.save(SaveData.of(DataField.SHADER_HASH, currentShaderHash));
            } else {
                ShaderData.debugLog("Current shader data directory hash: " + data.shaderHash);
                ShaderData.debugLog("Shaderpacks hash matches, data file is valid for this user");
            }
        }
        catch (IOException e) {
            ShaderData.debugLog("Error reading data file for validation: " + e.getMessage());
        }
        catch (JsonSyntaxException e) {
            ShaderData.debugLog("Invalid JSON format in data file during validation: " + e.getMessage());
        }
    }

    public static void save(SaveData ... updates) {
        if (updates == null || updates.length == 0) {
            ShaderData.debugLog("No updates provided to save");
            return;
        }
        ShaderData.debugLog("Saving " + updates.length + " field(s) to data file");
        try {
            JsonObject jsonObject;
            if (!Files.exists(Config.CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(Config.CONFIG_DIR, new FileAttribute[0]);
                ShaderData.debugLog("Created config directory: " + Config.CONFIG_DIR);
            }
            if (ShaderData.dataFileExists()) {
                try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(DATA_FILE, new OpenOption[0]), StandardCharsets.UTF_8);){
                    JsonElement element = GSON.fromJson((Reader)reader, JsonElement.class);
                    jsonObject = element != null && element.isJsonObject() ? element.getAsJsonObject() : new JsonObject();
                }
            } else {
                jsonObject = new JsonObject();
            }
            Set<String> allowedKeys = DataField.getAllowedKeys();
            HashSet<String> keysToRemove = new HashSet<String>();
            for (String key : jsonObject.keySet()) {
                if (allowedKeys.contains(key)) continue;
                keysToRemove.add(key);
            }
            if (!keysToRemove.isEmpty()) {
                ShaderData.debugLog("Removing " + keysToRemove.size() + " old/unknown field(s): " + keysToRemove);
                for (String key : keysToRemove) {
                    jsonObject.remove(key);
                }
            }
            block19: for (SaveData update : updates) {
                switch (update.field.ordinal()) {
                    case 0: 
                    case 1: 
                    case 3: {
                        jsonObject.addProperty(update.field.getJsonKey(), (Boolean)update.value);
                        ShaderData.debugLog("Updating " + (Object)((Object)update.field) + " to " + update.value);
                        continue block19;
                    }
                    case 2: {
                        jsonObject.addProperty(update.field.getJsonKey(), (String)update.value);
                        ShaderData.debugLog("Updating " + (Object)((Object)update.field) + " to " + update.value);
                    }
                }
            }
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(DATA_FILE, new OpenOption[0]), StandardCharsets.UTF_8);){
                GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
                ShaderData.debugLog("Successfully saved data to " + DATA_FILE);
                cachedData = null;
            }
        }
        catch (IOException e) {
            ShaderData.debugLog("Error saving data: " + e.getMessage());
        }
        catch (ClassCastException e) {
            ShaderData.debugLog("Invalid type for field update: " + e.getMessage());
        }
    }

    public static void saveShaderStyles(boolean styleReimagined, boolean styleUnbound) {
        ShaderData.save(SaveData.of(DataField.STYLE_REIMAGINED, styleReimagined), SaveData.of(DataField.STYLE_UNBOUND, styleUnbound));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PersistentShaderData load() {
        if (cachedData != null) {
            ShaderData.debugLog("Returning cached shader data");
            return cachedData;
        }
        ShaderData.debugLog("Loading shader data from " + DATA_FILE);
        if (!Files.exists(DATA_FILE, new LinkOption[0])) {
            ShaderData.debugLog("Data file does not exist, returning default values");
            cachedData = new PersistentShaderData();
            return cachedData;
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(DATA_FILE, new OpenOption[0]), StandardCharsets.UTF_8);){
            PersistentShaderData data = GSON.fromJson((Reader)reader, PersistentShaderData.class);
            if (data == null) {
                ShaderData.debugLog("Parsed data is null, returning default values");
                PersistentShaderData persistentShaderData = cachedData = new PersistentShaderData();
                return persistentShaderData;
            }
            PersistentShaderData persistentShaderData = cachedData = data;
            return persistentShaderData;
        }
        catch (IOException e) {
            ShaderData.debugLog("Error loading shader data: " + e.getMessage());
            cachedData = new PersistentShaderData();
            return cachedData;
        }
        catch (JsonSyntaxException e) {
            ShaderData.debugLog("Invalid JSON format in data file: " + e.getMessage());
            cachedData = new PersistentShaderData();
            return cachedData;
        }
    }

    public static boolean dataFileExists() {
        return Files.exists(DATA_FILE, new LinkOption[0]);
    }

    public static void deleteDataFile() {
        ShaderData.debugLog("Deleting data file: " + DATA_FILE);
        try {
            if (Files.exists(DATA_FILE, new LinkOption[0])) {
                Files.delete(DATA_FILE);
                ShaderData.debugLog("Successfully deleted data file");
                cachedData = null;
                return;
            }
            ShaderData.debugLog("Data file does not exist, nothing to delete");
        }
        catch (IOException e) {
            ShaderData.debugLog("Error deleting data file: " + e.getMessage());
        }
    }

    public static class SaveData {
        public final DataField field;
        public final Object value;

        private SaveData(DataField field, Object value) {
            this.field = field;
            this.value = value;
        }

        public static SaveData of(DataField field, Object value) {
            return new SaveData(field, value);
        }
    }

    public static enum DataField {
        STYLE_REIMAGINED("styleReimagined"),
        STYLE_UNBOUND("styleUnbound"),
        SHADER_HASH("shaderHash"),
        SUPPORT_EP_BUTTON("supportEPButtonVisible");

        private final String jsonKey;

        private DataField(String jsonKey) {
            this.jsonKey = jsonKey;
        }

        public String getJsonKey() {
            return this.jsonKey;
        }

        public static Set<String> getAllowedKeys() {
            HashSet<String> keys = new HashSet<String>();
            for (DataField field : DataField.values()) {
                keys.add(field.getJsonKey());
            }
            return keys;
        }
    }

    public static class PersistentShaderData {
        public Boolean styleReimagined = null;
        public Boolean styleUnbound = null;
        public String shaderHash = null;
        public Boolean supportEPButtonVisible = null;
    }
}

