/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.neoforge.mixin;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.integration.iris.IrisReloadManager;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.ModLoaderSpecifics;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class ReloadShadersOnDimensionChangeMixin {
    @Unique
    private static String euphoriaPatcher$lastDimension = null;

    @Unique
    private static void euphoriaPatcher$debugLog(String message) {
        EuphoriaLogger.debugLog("[ReloadShadersOnDimensionChangeMixin] " + message);
    }

    @Inject(method={"setLevel"}, at={@At(value="RETURN")})
    private void onDimensionChange(CallbackInfo ci) {
        ReloadShadersOnDimensionChangeMixin.euphoriaPatcher$debugLog("### EUPHORIA DIMENSION DETECTION - setLevel called ###");
        String currentDimension = ModLoaderSpecifics.getCurrentDimensionStatic();
        if (euphoriaPatcher$lastDimension == null) {
            euphoriaPatcher$lastDimension = currentDimension;
            ReloadShadersOnDimensionChangeMixin.euphoriaPatcher$debugLog("Initial dimension set to: " + currentDimension);
            return;
        }
        ReloadShadersOnDimensionChangeMixin.euphoriaPatcher$debugLog("!!! DIMENSION CHANGED: " + euphoriaPatcher$lastDimension + " -> " + currentDimension + " !!!");
        euphoriaPatcher$lastDimension = currentDimension;
        try {
            Minecraft.getInstance().execute(() -> {
                IrisReloadManager.findAndScheduleReload();
                ReloadShadersOnDimensionChangeMixin.euphoriaPatcher$debugLog("Scheduled shader reload after dimension change");
            });
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "Error scheduling shader reload: " + e.getMessage());
        }
    }
}

