/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.neoforge.mixin;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.integration.ShaderLoader;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.services.ShaderDetector;
import com.euphoriapatches.euphoria_patcher.util.ShaderData;
import com.euphoriapatches.euphoria_patcher.util.UpdateChecker;
import com.euphoriapatches.euphoria_patcher.util.VersionComparator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Pseudo
@Mixin(targets={"net.irisshaders.iris.gui.element.ShaderPackOptionList$HeaderEntry"}, remap=false)
public class IrisHeaderEntryMixin {
    @Unique
    private static String euphoriaPatcher$EuphoriaURL = "https://euphoriapatches.com/support";
    @Unique
    private long euphoriaPatcher$buttonHoverStartTime = 0L;
    @Unique
    private boolean euphoriaPatcher$isCurrentlyHovering = false;
    @Unique
    private static boolean euphoriaPatcher$hasShownExtendedTooltip = false;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false, require=0)
    private void onConstructor(CallbackInfo ci) {
        try {
            EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
            ShaderDetector shaderDetector = instance.getShaderDetector();
            Path currentShaderPackPath = ShaderLoader.getCurrentShaderpackPath();
            String buttonText = "Support EP";
            int buttonColor = 0;
            boolean isUpdateAvailable = this.euphoriaPatcher$isUpdateAvailable(shaderDetector, currentShaderPackPath);
            if (isUpdateAvailable) {
                buttonText = "Update EP!";
                buttonColor = 2;
                euphoriaPatcher$EuphoriaURL = "https://euphoriapatches.com/download";
            } else {
                euphoriaPatcher$EuphoriaURL = "https://euphoriapatches.com/support";
            }
            if (this.euphoriaPatcher$shouldShowEPButton()) {
                this.euphoriaPatcher$addEPIrisButton(buttonText, buttonColor);
            }
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Failed to add Iris EP button: " + e.getMessage());
            this.euphoriaPatcher$debugLog(EuphoriaLogger.getStackTrace(e));
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")}, remap=false, require=0)
    private void onRenderContent10Params(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta, CallbackInfo ci) {
        this.euphoriaPatcher$renderTooltipImpl(guiGraphics);
        this.euphoriaPatcher$recolorEPButtonWhileShift();
    }

    @Inject(method={"renderContent(Lnet/minecraft/client/gui/GuiGraphics;IIZF)V"}, at={@At(value="TAIL")}, remap=false, require=0)
    private void onRenderContent5Params(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta, CallbackInfo ci) {
        this.euphoriaPatcher$renderTooltipImpl(guiGraphics);
        this.euphoriaPatcher$recolorEPButtonWhileShift();
    }

    @Unique
    private void euphoriaPatcher$renderTooltipImpl(GuiGraphics guiGraphics) {
        try {
            Object utilityButtons = this.euphoriaPatcher$getFieldValue(this, "utilityButtons");
            Object resetButton = this.euphoriaPatcher$getFieldValue(this, "resetButton");
            if (utilityButtons == null) {
                return;
            }
            this.euphoriaPatcher$renderTooltip(guiGraphics, utilityButtons, resetButton);
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Error rendering tooltip: " + e.getMessage());
            this.euphoriaPatcher$debugLog(EuphoriaLogger.getStackTrace(e));
        }
    }

    @Unique
    private boolean euphoriaPatcher$shouldShowEPButton() {
        EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
        ShaderDetector shaderDetector = instance.getShaderDetector();
        Path currentShaderPackPath = ShaderLoader.getCurrentShaderpackPath();
        boolean isUpdateAvailable = this.euphoriaPatcher$isUpdateAvailable(shaderDetector, currentShaderPackPath);
        ShaderData.PersistentShaderData data = ShaderData.load();
        boolean userAllowsSupportButton = false;
        if (data.supportEPButtonVisible == null || data.supportEPButtonVisible.booleanValue()) {
            this.euphoriaPatcher$debugLog("User has not dismissed EP support button");
            userAllowsSupportButton = true;
        } else {
            this.euphoriaPatcher$debugLog("User has dismissed EP support button - not adding button");
        }
        boolean shouldShowSupportButton = shaderDetector.noDevVersionsInstalled() && userAllowsSupportButton;
        boolean secondCondition = shouldShowSupportButton || isUpdateAvailable;
        return shaderDetector.isEuphoriaPatchesShader(currentShaderPackPath) && secondCondition;
    }

    @Unique
    private boolean euphoriaPatcher$isShiftDown() {
        try {
            Minecraft minecraft = Minecraft.getInstance();
            try {
                Method method = Minecraft.class.getMethod("hasShiftDown", new Class[0]);
                return (Boolean)method.invoke((Object)minecraft, new Object[0]);
            }
            catch (Exception e) {
                Method method = Screen.class.getMethod("hasShiftDown", new Class[0]);
                return (Boolean)method.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Error detecting shift key: " + e.getMessage());
            return false;
        }
    }

    @Unique
    private void euphoriaPatcher$recolorEPButtonWhileShift() {
        try {
            Object utilityButtons = this.euphoriaPatcher$getFieldValue(this, "utilityButtons");
            Object resetButton = this.euphoriaPatcher$getFieldValue(this, "resetButton");
            if (utilityButtons == null) {
                return;
            }
            EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
            ShaderDetector shaderDetector = instance.getShaderDetector();
            Path currentShaderPackPath = ShaderLoader.getCurrentShaderpackPath();
            boolean isUpdateAvailable = this.euphoriaPatcher$isUpdateAvailable(shaderDetector, currentShaderPackPath);
            boolean shiftDown = this.euphoriaPatcher$isShiftDown();
            MutableComponent buttonText = isUpdateAvailable ? Component.literal((String)"Update EP!").withStyle(ChatFormatting.GREEN) : (shiftDown ? Component.literal((String)"Support EP").withStyle(ChatFormatting.RED) : Component.literal((String)"Support EP").withStyle(ChatFormatting.LIGHT_PURPLE));
            Object children = utilityButtons.getClass().getMethod("children", new Class[0]).invoke(utilityButtons, new Object[0]);
            Iterable childrenIterable = (Iterable)children;
            Class<?> textButtonElementClass = Class.forName("net.irisshaders.iris.gui.element.IrisElementRow$TextButtonElement");
            for (Object child : childrenIterable) {
                if (!textButtonElementClass.isInstance(child) || child == resetButton) continue;
                Field textField = child.getClass().getField("text");
                textField.setAccessible(true);
                textField.set(child, buttonText);
                break;
            }
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Error recoloring EP button: " + e.getMessage());
        }
    }

    @Unique
    private void euphoriaPatcher$addEPIrisButton(String buttonTextLiteral, int buttonColor) {
        try {
            Object utilityButtons = this.euphoriaPatcher$getFieldValue(this, "utilityButtons");
            Object screen = this.euphoriaPatcher$getFieldValue(this, "screen");
            if (utilityButtons == null) {
                this.euphoriaPatcher$debugLog("utilityButtons field not found");
                return;
            }
            MutableComponent buttonText = Component.literal((String)buttonTextLiteral).withStyle(switch (buttonColor) {
                case 1 -> ChatFormatting.RED;
                case 2 -> ChatFormatting.GREEN;
                case 3 -> ChatFormatting.BLUE;
                default -> ChatFormatting.LIGHT_PURPLE;
            });
            Minecraft minecraft = Minecraft.getInstance();
            Object supportEPButton = this.euphoriaPatcher$createIrisButton(buttonText, () -> this.euphoriaPatcher$handleSupportEPButtonClick(minecraft, screen));
            this.euphoriaPatcher$addButtonToRow(utilityButtons, supportEPButton, 66);
            this.euphoriaPatcher$debugLog("Successfully added Iris EP button");
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Error in addEPIrisButton: " + e.getMessage());
            this.euphoriaPatcher$debugLog(EuphoriaLogger.getStackTrace(e));
        }
    }

    @Unique
    private Object euphoriaPatcher$createIrisButton(Object buttonText, Runnable action) throws Exception {
        Class<?> textButtonElementClass = Class.forName("net.irisshaders.iris.gui.element.IrisElementRow$TextButtonElement");
        for (Constructor<?> ctor : textButtonElementClass.getConstructors()) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length != 2) continue;
            Class<?> actionClass = paramTypes[1];
            Object actionProxy = Proxy.newProxyInstance(actionClass.getClassLoader(), new Class[]{actionClass}, (proxy, method, args) -> {
                action.run();
                return true;
            });
            return ctor.newInstance(buttonText, actionProxy);
        }
        throw new Exception("Could not find TextButtonElement constructor");
    }

    @Unique
    private void euphoriaPatcher$addButtonToRow(Object utilityButtons, Object button, int width) throws Exception {
        for (Method method : utilityButtons.getClass().getMethods()) {
            Class<?>[] paramTypes;
            if (!method.getName().equals("add") || method.getParameterCount() != 2 || (paramTypes = method.getParameterTypes())[1] != Integer.TYPE && paramTypes[1] != Integer.class) continue;
            method.invoke(utilityButtons, button, width);
            return;
        }
        throw new Exception("Could not find add method on utilityButtons");
    }

    @Unique
    private void euphoriaPatcher$handleSupportEPButtonClick(Minecraft minecraft, Object screen) {
        try {
            this.euphoriaPatcher$playButtonClickSound();
            if (this.euphoriaPatcher$isShiftDown()) {
                this.euphoriaPatcher$debugLog("Pressed Shift while clicking EP button - removing button");
                ShaderData.save(ShaderData.SaveData.of(ShaderData.DataField.SUPPORT_EP_BUTTON, false));
                return;
            }
            ConfirmLinkScreen confirmScreen = new ConfirmLinkScreen(confirmed -> {
                if (confirmed) {
                    this.euphoriaPatcher$openUrl();
                }
                minecraft.setScreen((Screen)screen);
            }, euphoriaPatcher$EuphoriaURL, true);
            minecraft.setScreen((Screen)confirmScreen);
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Error handling button click: " + e.getMessage());
            this.euphoriaPatcher$debugLog(EuphoriaLogger.getStackTrace(e));
        }
    }

    @Unique
    private void euphoriaPatcher$playButtonClickSound() {
        try {
            Class<?> guiUtilClass = Class.forName("net.irisshaders.iris.gui.GuiUtil");
            guiUtilClass.getMethod("playButtonClickSound", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private void euphoriaPatcher$openUrl() {
        try {
            Class<?> utilClass;
            try {
                utilClass = Class.forName("net.minecraft.Util");
            }
            catch (ClassNotFoundException ex) {
                utilClass = Class.forName("net.minecraft.util.Util");
            }
            Object platform = utilClass.getMethod("getPlatform", new Class[0]).invoke(null, new Object[0]);
            platform.getClass().getMethod("openUri", String.class).invoke(platform, euphoriaPatcher$EuphoriaURL);
            this.euphoriaPatcher$debugLog("Successfully opened URL");
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Failed to open URL: " + e.getMessage());
        }
    }

    @Unique
    private void euphoriaPatcher$renderTooltip(GuiGraphics guiGraphics, Object utilityButtons, Object resetButton) throws Exception {
        Minecraft minecraft = Minecraft.getInstance();
        Object children = utilityButtons.getClass().getMethod("children", new Class[0]).invoke(utilityButtons, new Object[0]);
        Iterable childrenIterable = (Iterable)children;
        Class<?> textButtonElementClass = Class.forName("net.irisshaders.iris.gui.element.IrisElementRow$TextButtonElement");
        for (Object child : childrenIterable) {
            if (!textButtonElementClass.isInstance(child) || child == resetButton) continue;
            boolean isHovered = (Boolean)child.getClass().getMethod("isHovered", new Class[0]).invoke(child, new Object[0]);
            boolean isFocused = false;
            if (child instanceof Renderable) {
                try {
                    isFocused = (Boolean)child.getClass().getMethod("isFocused", new Class[0]).invoke(child, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isHovered || isFocused) {
                ChatFormatting colorFormatting;
                Object tooltipString;
                Path currentShaderPackPath;
                if (!euphoriaPatcher$hasShownExtendedTooltip) {
                    long hoverDuration;
                    long currentTime = System.currentTimeMillis();
                    if (!this.euphoriaPatcher$isCurrentlyHovering) {
                        this.euphoriaPatcher$buttonHoverStartTime = currentTime;
                        this.euphoriaPatcher$isCurrentlyHovering = true;
                    }
                    if ((hoverDuration = currentTime - this.euphoriaPatcher$buttonHoverStartTime) >= 1715L) {
                        euphoriaPatcher$hasShownExtendedTooltip = true;
                    }
                }
                boolean shiftDown = this.euphoriaPatcher$isShiftDown();
                EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
                ShaderDetector shaderDetector = instance.getShaderDetector();
                boolean isUpdateAvailable = this.euphoriaPatcher$isUpdateAvailable(shaderDetector, currentShaderPackPath = ShaderLoader.getCurrentShaderpackPath());
                if (isUpdateAvailable) {
                    tooltipString = "Update Euphoria Patches!";
                    colorFormatting = ChatFormatting.GREEN;
                } else if (shiftDown) {
                    tooltipString = "Remove Support Button? Requires re-entering the menu to show effect";
                    colorFormatting = ChatFormatting.RED;
                } else {
                    String removeString = "";
                    if (euphoriaPatcher$hasShownExtendedTooltip) {
                        removeString = " (SHIFT Click to Remove)";
                    }
                    tooltipString = "Support Euphoria Patches!" + removeString;
                    colorFormatting = ChatFormatting.LIGHT_PURPLE;
                }
                MutableComponent tooltipText = Component.literal((String)tooltipString).withStyle(colorFormatting);
                Object rect = child.getClass().getMethod("getRectangle", new Class[0]).invoke(child, new Object[0]);
                int rightBound = (Integer)rect.getClass().getMethod("getBoundInDirection", ScreenDirection.class).invoke(rect, ScreenDirection.RIGHT);
                Object position = rect.getClass().getMethod("position", new Class[0]).invoke(rect, new Object[0]);
                int yPos = (Integer)position.getClass().getMethod("y", new Class[0]).invoke(position, new Object[0]);
                int textWidth = minecraft.font.width((FormattedText)tooltipText);
                int tooltipX = rightBound - (textWidth + 10);
                int tooltipY = yPos - 16;
                int finalTooltipX = tooltipX;
                int finalTooltipY = tooltipY;
                Class<?> shaderPackScreenClass = Class.forName("net.irisshaders.iris.gui.screen.ShaderPackScreen");
                Object renderQueue = shaderPackScreenClass.getField("TOP_LAYER_RENDER_QUEUE").get(null);
                Class<?> guiUtilClass = Class.forName("net.irisshaders.iris.gui.GuiUtil");
                Runnable renderTask = () -> {
                    try {
                        guiUtilClass.getMethod("drawTextPanel", minecraft.font.getClass(), GuiGraphics.class, Component.class, Integer.TYPE, Integer.TYPE).invoke(null, minecraft.font, guiGraphics, tooltipText, finalTooltipX, finalTooltipY);
                    }
                    catch (Exception e) {
                        this.euphoriaPatcher$debugLog("Error in render task: " + e.getMessage());
                    }
                };
                renderQueue.getClass().getMethod("add", Object.class).invoke(renderQueue, renderTask);
                break;
            }
            this.euphoriaPatcher$isCurrentlyHovering = false;
            break;
        }
    }

    @Unique
    private boolean euphoriaPatcher$isUpdateAvailable(ShaderDetector shaderDetector, Path currentShaderPackPath) {
        return UpdateChecker.shouldUserUpdate() && VersionComparator.isNewerVersion(UpdateChecker.getNewModVersion(), shaderDetector.readVersionFromPackJson(currentShaderPackPath));
    }

    @Unique
    private Object euphoriaPatcher$getFieldValue(Object obj, String fieldName) {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                this.euphoriaPatcher$debugLog("Error accessing field " + fieldName + ": " + e.getMessage());
                return null;
            }
        }
        this.euphoriaPatcher$debugLog("Field " + fieldName + " not found in class hierarchy");
        return null;
    }

    @Unique
    private void euphoriaPatcher$debugLog(String message) {
        EuphoriaLogger.debugLog("[IrisHeaderEntryMixin] " + message);
    }
}

