/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.integration;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.integration.iris.IrisDefineHelper;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.ModsDirectory;
import com.euphoriapatches.euphoria_patcher.util.ShaderVersionComparator;
import com.euphoriapatches.euphoria_patcher.util.VersionComparator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Stream;

public class ShaderLoader {
    public static final String IRIS = "iris";
    public static final String OCULUS = "oculus";
    public static final String OPTIFINE = "optifine";
    public static final String ANGELICA = "angelica";
    public static final String UNKNOWN = "unknown";
    private static final String MODERN_IRIS_CLASS = "net.irisshaders.iris.Iris";
    private static final String LEGACY_IRIS_CLASS = "net.coderbot.iris.Iris";
    private static final String OPTIFINE_CLASS = "optifine.OptiFineTweaker";
    private static File cachedShaderFile = null;
    private static boolean shaderFileSearched = false;
    private static String cachedShaderLoader = null;
    private static String cachedMCVersion = null;
    private static Integer cachedShaderLoaderVersion = null;
    private static Path shaderLoaderConfigPath = null;
    private static final Map<String, Path> shaderpackPathCache = new HashMap<String, Path>();
    private static Path cachedCurrentShaderpackPath = null;
    private static long lastConfigModifiedTime = 0L;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderLoader] " + message);
    }

    private static boolean checkClassExists(String className) {
        try {
            String resourceName = className.replace('.', '/') + ".class";
            boolean exists = ShaderLoader.class.getClassLoader().getResource(resourceName) != null;
            ShaderLoader.debugLog("Class check for " + className + ": " + (exists ? "found" : "not found"));
            return exists;
        }
        catch (Exception e) {
            ShaderLoader.debugLog("Exception checking class " + className + ": " + e.getMessage());
            return false;
        }
    }

    public static Class<?> findIrisClass() {
        if (ShaderLoader.checkClassExists(MODERN_IRIS_CLASS)) {
            try {
                return Class.forName(MODERN_IRIS_CLASS);
            }
            catch (ClassNotFoundException e) {
                ShaderLoader.debugLog("Class exists but couldn't load: net.irisshaders.iris.Iris");
            }
        }
        if (ShaderLoader.checkClassExists(LEGACY_IRIS_CLASS)) {
            try {
                return Class.forName(LEGACY_IRIS_CLASS);
            }
            catch (ClassNotFoundException e) {
                ShaderLoader.debugLog("Class exists but couldn't load: net.coderbot.iris.Iris");
            }
        }
        return null;
    }

    public static boolean isIrisRunning() {
        ShaderLoader.debugLog("Iris is running: " + IrisDefineHelper.isIrisRunning);
        return IrisDefineHelper.isIrisRunning;
    }

    private static String getModIdFromClass(Class<?> classObj) {
        try {
            try {
                Field modNameField = classObj.getField("MODNAME");
                Object modNameValue = modNameField.get(null);
                if (modNameValue instanceof String) {
                    String modName = (String)modNameValue;
                    ShaderLoader.debugLog("Found MODNAME field in " + classObj.getName() + ": " + modName);
                    switch (modName) {
                        case "Iris": {
                            ShaderLoader.debugLog("Detected Iris via MODNAME='Iris'");
                            return IRIS;
                        }
                        case "Oculus": {
                            ShaderLoader.debugLog("Detected Oculus via MODNAME='Oculus'");
                            return OCULUS;
                        }
                        case "AngelicaShaders": {
                            ShaderLoader.debugLog("Detected Angelica via MODNAME='AngelicaShaders'");
                            return ANGELICA;
                        }
                    }
                }
            }
            catch (NoSuchFieldException e) {
                ShaderLoader.debugLog("MODNAME field not found");
            }
        }
        catch (Exception e) {
            ShaderLoader.debugLog("Error reading fields from " + classObj.getName() + ": " + e.getMessage());
        }
        return null;
    }

    private static String detectShaderLoaderByClass() {
        ShaderLoader.debugLog("Attempting shader loader detection via class checks");
        Class<?> irisClass = ShaderLoader.findIrisClass();
        if (irisClass != null) {
            String modId = ShaderLoader.getModIdFromClass(irisClass);
            if (IRIS.equals(modId)) {
                ShaderLoader.debugLog("Detected IRIS via class check and MODNAME field");
                return IRIS;
            }
            if (OCULUS.equals(modId)) {
                ShaderLoader.debugLog("Detected OCULUS via class check and MODNAME field");
                return OCULUS;
            }
            if (ANGELICA.equals(modId)) {
                ShaderLoader.debugLog("Detected ANGELICA via class check and MODNAME field");
                return ANGELICA;
            }
            ShaderLoader.debugLog("Found Iris-like class but MODNAME was: " + modId);
            ShaderLoader.debugLog("Assuming IRIS as default for Iris-like class");
            return IRIS;
        }
        if (ShaderLoader.checkClassExists(OPTIFINE_CLASS)) {
            ShaderLoader.debugLog("Detected OPTIFINE via class check");
            return OPTIFINE;
        }
        ShaderLoader.debugLog("No shader loader detected via class checks");
        return null;
    }

    private static String detectShaderLoaderByFilename(File shaderFile) {
        ShaderLoader.debugLog("Attempting shader loader detection via filename (fallback method)");
        if (shaderFile == null) {
            ShaderLoader.debugLog("No shader file provided for filename detection");
            return UNKNOWN;
        }
        String fileName = shaderFile.getName().toLowerCase(Locale.ROOT);
        ShaderLoader.debugLog("Analyzing file name: " + fileName);
        if (fileName.startsWith(IRIS)) {
            ShaderLoader.debugLog("Detected IRIS via filename");
            return IRIS;
        }
        if (fileName.startsWith(OCULUS) || fileName.startsWith("mekalus")) {
            ShaderLoader.debugLog("Detected OCULUS via filename" + (fileName.startsWith("mekalus") ? " (Mekalus fork)" : ""));
            return OCULUS;
        }
        if (fileName.startsWith(OPTIFINE)) {
            ShaderLoader.debugLog("Detected OPTIFINE via filename");
            return OPTIFINE;
        }
        if (fileName.startsWith(ANGELICA)) {
            ShaderLoader.debugLog("Detected ANGELICA via filename");
            return ANGELICA;
        }
        ShaderLoader.debugLog("Could not determine shader loader type from filename");
        return UNKNOWN;
    }

    private static File findShaderLoaderFile() {
        if (shaderFileSearched) {
            ShaderLoader.debugLog("Using cached shader file result: " + (cachedShaderFile != null ? cachedShaderFile.getName() : "null"));
            return cachedShaderFile;
        }
        ShaderLoader.debugLog("Searching for shader loader file in mods directory");
        try {
            File modsFolder = ModsDirectory.get().toFile();
            File[] modFiles = modsFolder.listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".jar"));
            if (modFiles != null) {
                ShaderLoader.debugLog("Found " + modFiles.length + " JAR files in mods directory");
                for (File modFile : modFiles) {
                    String fileName = modFile.getName().toLowerCase(Locale.ROOT);
                    ShaderLoader.debugLog("Checking file: " + fileName);
                    if (fileName.contains("compat") || fileName.contains("addon") || fileName.contains("compatibility") || fileName.contains("flywheel")) {
                        ShaderLoader.debugLog("Skipping compatibility/addon mod: " + fileName);
                        continue;
                    }
                    if ((!fileName.startsWith(IRIS) || !fileName.contains("fabric") && !fileName.contains("neoforge") && !fileName.contains("+mc")) && !fileName.startsWith("oculus-mc") && !fileName.startsWith("mekalus-mc") && !fileName.startsWith("optifine_") && !fileName.startsWith(ANGELICA)) continue;
                    cachedShaderFile = modFile;
                    shaderFileSearched = true;
                    ShaderLoader.debugLog("Found shader loader file: " + modFile.getName());
                    return cachedShaderFile;
                }
            }
            ShaderLoader.debugLog("No shader loader file found");
            shaderFileSearched = true;
            return null;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "Error finding shader loader: " + e.getMessage());
            ShaderLoader.debugLog("Exception while searching for shader loader: " + e.getMessage());
            shaderFileSearched = true;
            return null;
        }
    }

    public static String getShaderLoader() {
        if (cachedShaderLoader != null) {
            ShaderLoader.debugLog("Using cached shader loader type: " + cachedShaderLoader);
            return cachedShaderLoader;
        }
        ShaderLoader.debugLog("Determining shader loader type");
        String detectedByClass = ShaderLoader.detectShaderLoaderByClass();
        if (detectedByClass != null) {
            cachedShaderLoader = detectedByClass;
            return cachedShaderLoader;
        }
        ShaderLoader.debugLog("Class-based detection failed, falling back to filename detection");
        File shaderFile = ShaderLoader.findShaderLoaderFile();
        if (shaderFile == null) {
            ShaderLoader.debugLog("No shader file found, returning UNKNOWN");
            EuphoriaPatcher.log(2, 0, "No shader loader mod was found");
            cachedShaderLoader = UNKNOWN;
            return cachedShaderLoader;
        }
        cachedShaderLoader = ShaderLoader.detectShaderLoaderByFilename(shaderFile);
        return cachedShaderLoader;
    }

    public static String getShaderLoaderMCVersion() {
        if (cachedMCVersion != null) {
            ShaderLoader.debugLog("Using cached MC version: " + cachedMCVersion);
            return cachedMCVersion;
        }
        ShaderLoader.debugLog("Extracting Minecraft version from shader loader filename");
        try {
            File shaderFile = ShaderLoader.findShaderLoaderFile();
            if (shaderFile == null) {
                ShaderLoader.debugLog("No shader file found, returning UNKNOWN version");
                cachedMCVersion = UNKNOWN;
                return cachedMCVersion;
            }
            String fileName = shaderFile.getName();
            String lowerFileName = fileName.toLowerCase(Locale.ROOT);
            String extractedVersion = null;
            ShaderLoader.debugLog("Parsing version from filename: " + fileName);
            if (lowerFileName.startsWith(ANGELICA)) {
                ShaderLoader.debugLog("Detected Angelica format - always for Minecraft 1.7.10");
                extractedVersion = "1.7.10";
                ShaderLoader.debugLog("Set version to 1.7.10 for Angelica");
            } else if (lowerFileName.startsWith("optifine_")) {
                ShaderLoader.debugLog("Detected OptiFine format");
                String[] parts = fileName.split("_");
                if (parts.length >= 2) {
                    extractedVersion = parts[1];
                    ShaderLoader.debugLog("Extracted version: " + extractedVersion);
                }
            } else if (lowerFileName.startsWith(IRIS)) {
                int jarIndex;
                ShaderLoader.debugLog("Detected Iris format");
                int mcIndex = lowerFileName.indexOf("+mc");
                if (mcIndex != -1 && (jarIndex = lowerFileName.indexOf(".jar")) != -1 && jarIndex > mcIndex) {
                    extractedVersion = fileName.substring(mcIndex + 3, jarIndex);
                    ShaderLoader.debugLog("Extracted version: " + extractedVersion);
                }
            } else if (lowerFileName.startsWith(OCULUS) || lowerFileName.startsWith("mekalus")) {
                int dashAfterMc;
                ShaderLoader.debugLog("Detected " + (lowerFileName.startsWith("mekalus") ? "Mekalus" : "Oculus") + " format");
                int mcIndex = lowerFileName.indexOf("-mc");
                if (mcIndex != -1 && (dashAfterMc = fileName.indexOf(45, mcIndex + 3)) != -1) {
                    extractedVersion = fileName.substring(mcIndex + 3, dashAfterMc);
                    ShaderLoader.debugLog("Extracted version: " + extractedVersion);
                }
            }
            if (extractedVersion != null) {
                Matcher matcher = ShaderVersionComparator.VERSION_PATTERN.matcher(extractedVersion);
                if (matcher.matches()) {
                    ShaderLoader.debugLog("Valid version format: " + extractedVersion);
                    cachedMCVersion = extractedVersion;
                    return cachedMCVersion;
                }
                ShaderLoader.debugLog("Invalid version format: " + extractedVersion);
                EuphoriaPatcher.log(1, 0, "Invalid version format detected: " + extractedVersion);
            } else {
                ShaderLoader.debugLog("Could not extract version from filename");
            }
            ShaderLoader.debugLog("Setting version to UNKNOWN");
            cachedMCVersion = UNKNOWN;
            return cachedMCVersion;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "Error extracting Minecraft version: " + e.getMessage());
            ShaderLoader.debugLog("Exception extracting Minecraft version: " + e.getMessage());
            cachedMCVersion = UNKNOWN;
            return cachedMCVersion;
        }
    }

    public static boolean isVersionGreaterOrEqual(String version, String minVersion) {
        if (version == null || minVersion == null || UNKNOWN.equals(version) || UNKNOWN.equals(minVersion)) {
            return false;
        }
        try {
            return VersionComparator.compareVersionStrings(version, minVersion) >= 0;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(1, 0, "Error comparing versions: " + e.getMessage());
            return false;
        }
    }

    public static boolean isMinecraftVersionAtLeast(String minVersion) {
        String currentVersion = ShaderLoader.getShaderLoaderMCVersion();
        return ShaderLoader.isVersionGreaterOrEqual(currentVersion, minVersion);
    }

    public static int getShaderLoaderVersion() {
        if (cachedShaderLoaderVersion != null) {
            ShaderLoader.debugLog("Using cached shader loader version: " + cachedShaderLoaderVersion);
            return cachedShaderLoaderVersion;
        }
        ShaderLoader.debugLog("Extracting shader loader version from filename");
        try {
            File shaderFile = ShaderLoader.findShaderLoaderFile();
            if (shaderFile == null) {
                ShaderLoader.debugLog("No shader file found, returning 0");
                cachedShaderLoaderVersion = 0;
                return cachedShaderLoaderVersion;
            }
            String fileName = shaderFile.getName();
            String lowerFileName = fileName.toLowerCase(Locale.ROOT);
            String extractedVersion = null;
            ShaderLoader.debugLog("Parsing shader loader version from filename: " + fileName);
            if (lowerFileName.startsWith(IRIS)) {
                ShaderLoader.debugLog("Detected Iris format");
                int fabricIndex = lowerFileName.indexOf("-fabric-");
                int mcIndex = lowerFileName.indexOf("+mc");
                if (fabricIndex != -1 && mcIndex != -1 && mcIndex > fabricIndex) {
                    extractedVersion = fileName.substring(fabricIndex + 8, mcIndex);
                    ShaderLoader.debugLog("Extracted Iris version: " + extractedVersion);
                }
            } else if (lowerFileName.startsWith(OCULUS) || lowerFileName.startsWith("mekalus")) {
                ShaderLoader.debugLog("Detected " + (lowerFileName.startsWith("mekalus") ? "Mekalus" : "Oculus") + " format");
                int lastDashIndex = fileName.lastIndexOf(45);
                int jarIndex = lowerFileName.indexOf(".jar");
                if (lastDashIndex != -1 && jarIndex != -1 && jarIndex > lastDashIndex) {
                    String fullVersion = fileName.substring(lastDashIndex + 1, jarIndex);
                    if (lowerFileName.startsWith("mekalus") && fullVersion.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) {
                        String[] versionParts = fullVersion.split("\\.");
                        extractedVersion = versionParts[0] + "." + versionParts[1] + "." + versionParts[2];
                        ShaderLoader.debugLog("Simplified Mekalus version from " + fullVersion + " to " + extractedVersion);
                    } else {
                        extractedVersion = fullVersion;
                    }
                    ShaderLoader.debugLog("Extracted version: " + extractedVersion);
                }
            } else if (lowerFileName.startsWith(ANGELICA)) {
                ShaderLoader.debugLog("Detected Angelica format");
                int angelicaIndex = lowerFileName.indexOf("angelica-");
                int betaIndex = lowerFileName.indexOf("-beta");
                if (angelicaIndex != -1 && betaIndex != -1 && betaIndex > angelicaIndex) {
                    extractedVersion = fileName.substring(angelicaIndex + 9, betaIndex);
                    ShaderLoader.debugLog("Extracted Angelica version: " + extractedVersion);
                }
            } else if (lowerFileName.startsWith(OPTIFINE)) {
                ShaderLoader.debugLog("OptiFine detected - returning version 0 as specified");
                cachedShaderLoaderVersion = 0;
                return cachedShaderLoaderVersion;
            }
            if (extractedVersion != null) {
                try {
                    int versionInt = ShaderVersionComparator.convertVersionNumberToInt(extractedVersion);
                    ShaderLoader.debugLog("Converted shader loader version to integer: " + versionInt);
                    cachedShaderLoaderVersion = versionInt;
                    return cachedShaderLoaderVersion;
                }
                catch (Exception e) {
                    ShaderLoader.debugLog("Error converting shader loader version to int: " + e.getMessage());
                }
            } else {
                ShaderLoader.debugLog("Could not extract shader loader version from filename");
            }
            ShaderLoader.debugLog("Setting shader loader version to 0");
            cachedShaderLoaderVersion = 0;
            return cachedShaderLoaderVersion;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "Error extracting shader loader version: " + e.getMessage());
            ShaderLoader.debugLog("Exception extracting shader loader version: " + e.getMessage());
            cachedShaderLoaderVersion = 0;
            return cachedShaderLoaderVersion;
        }
    }

    public static String[] getShaderLoaderVersionDefine() {
        String shaderLoader;
        int version = ShaderLoader.getShaderLoaderVersion();
        switch (shaderLoader = ShaderLoader.getShaderLoader()) {
            case "iris": {
                return new String[]{"EUPHORIA_PATCHES_IRIS_VERSION", String.valueOf(version)};
            }
            case "oculus": {
                return new String[]{"EUPHORIA_PATCHES_OCULUS_VERSION", String.valueOf(version)};
            }
            case "angelica": {
                return new String[]{"EUPHORIA_PATCHES_ANGELICA_VERSION", String.valueOf(version)};
            }
        }
        return null;
    }

    public static Path getShaderLoaderConfigPath() {
        String shaderLoader;
        if (shaderLoaderConfigPath != null && Files.exists(shaderLoaderConfigPath, new LinkOption[0])) {
            ShaderLoader.debugLog("Using cached shader loader config path: " + shaderLoaderConfigPath);
            return shaderLoaderConfigPath;
        }
        switch (shaderLoader = ShaderLoader.getShaderLoader()) {
            case "iris": {
                Path configPath = EuphoriaPatcher.configDirectory.resolve("iris.properties");
                if (!Files.exists(configPath, new LinkOption[0])) break;
                ShaderLoader.debugLog("Found Iris config at: " + configPath);
                shaderLoaderConfigPath = configPath;
                return shaderLoaderConfigPath;
            }
            case "oculus": {
                Path configPath = EuphoriaPatcher.configDirectory.resolve("oculus.properties");
                if (!Files.exists(configPath, new LinkOption[0])) break;
                ShaderLoader.debugLog("Found Oculus config at: " + configPath);
                shaderLoaderConfigPath = configPath;
                return shaderLoaderConfigPath;
            }
            case "optifine": {
                Path configPath = EuphoriaPatcher.shaderpacks.getParent().resolve("optionsshaders.txt");
                if (!Files.exists(configPath, new LinkOption[0])) break;
                ShaderLoader.debugLog("Found OptiFine config at: " + configPath);
                shaderLoaderConfigPath = configPath;
                return shaderLoaderConfigPath;
            }
            case "angelica": {
                Path configPath = EuphoriaPatcher.configDirectory.resolve("shaders.properties");
                if (!Files.exists(configPath, new LinkOption[0])) break;
                ShaderLoader.debugLog("Found Angelica config at: " + configPath);
                shaderLoaderConfigPath = configPath;
                return shaderLoaderConfigPath;
            }
            default: {
                Path configPath = EuphoriaPatcher.configDirectory.resolve("iris.properties");
                if (Files.exists(configPath, new LinkOption[0])) {
                    shaderLoaderConfigPath = configPath;
                    return shaderLoaderConfigPath;
                }
                configPath = EuphoriaPatcher.configDirectory.resolve("oculus.properties");
                if (Files.exists(configPath, new LinkOption[0])) {
                    shaderLoaderConfigPath = configPath;
                    return shaderLoaderConfigPath;
                }
                configPath = EuphoriaPatcher.shaderpacks.getParent().resolve("optionsshaders.txt");
                if (Files.exists(configPath, new LinkOption[0])) {
                    shaderLoaderConfigPath = configPath;
                    return shaderLoaderConfigPath;
                }
                configPath = EuphoriaPatcher.configDirectory.resolve("shaders.properties");
                if (!Files.exists(configPath, new LinkOption[0])) break;
                shaderLoaderConfigPath = configPath;
                return shaderLoaderConfigPath;
            }
        }
        ShaderLoader.debugLog("No shader loader config found");
        shaderLoaderConfigPath = null;
        return null;
    }

    /*
     * Exception decompiling
     */
    public static Path getCurrentShaderpackPath() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getCurrentShaderpackName() {
        Path shaderpackPath = ShaderLoader.getCurrentShaderpackPath();
        if (shaderpackPath != null) {
            return shaderpackPath.getFileName().toString();
        }
        return null;
    }

    private static Path findShaderpackByName(String shaderpackName) throws IOException {
        try {
            Path directPath = EuphoriaPatcher.shaderpacks.resolve(shaderpackName);
            if (Files.exists(directPath, new LinkOption[0])) {
                ShaderLoader.debugLog("Found shader directly: " + directPath);
                return directPath;
            }
        }
        catch (InvalidPathException e) {
            ShaderLoader.debugLog("Invalid path characters in shader name: " + e.getMessage());
        }
        ShaderLoader.debugLog("Direct path resolution failed for: " + shaderpackName + ", trying directory scan");
        String normalizedName = ShaderLoader.normalizeShaderName(shaderpackName);
        ShaderLoader.debugLog("Normalized shader name: " + normalizedName);
        boolean isErrorShader = shaderpackName.contains("EuphoriaPatches") && shaderpackName.contains("Error") && shaderpackName.contains("Shader");
        try (Stream<Path> fileStream = Files.list(EuphoriaPatcher.shaderpacks);){
            Path result = fileStream.filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(path -> {
                String fileName = path.getFileName().toString();
                if (fileName.equals(shaderpackName)) {
                    ShaderLoader.debugLog("Found exact shader match: " + fileName);
                    return true;
                }
                if (isErrorShader && fileName.contains("EuphoriaPatches") && fileName.contains("Error") && fileName.contains("Shader")) {
                    ShaderLoader.debugLog("Found error shader: " + fileName);
                    return true;
                }
                String normalizedFileName = ShaderLoader.normalizeShaderName(fileName);
                boolean matches = normalizedFileName.equals(normalizedName);
                if (matches) {
                    ShaderLoader.debugLog("Found matching shader via normalization: " + fileName);
                }
                return matches;
            }).findFirst().orElse(null);
            if (result == null) {
                ShaderLoader.debugLog("No matching shader found in directory scan");
            }
            Path path2 = result;
            return path2;
        }
    }

    private static String normalizeShaderName(String name) {
        String withoutSection = name.replace("\u00a7", "").replace("\\u00A7", "");
        String safeChars = withoutSection.replaceAll("[^a-zA-Z0-9_ \\-.+()\\[\\]{}]", "");
        if (!name.equals(safeChars)) {
            ShaderLoader.debugLog("Normalized '" + name + "' to '" + safeChars + "'");
        }
        return safeChars.trim();
    }
}

