/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class ShaderpacksWatcher {
    private final Path shaderpacks;
    private final WatchService watchService;
    private final ScheduledExecutorService executor;
    private final EuphoriaPatcher patcher;
    private boolean isRunning = false;
    private final Set<String> processedFiles = new HashSet<String>();
    private final Set<String> invalidByteSizeFiles = new HashSet<String>();
    private final Map<String, FileMetadata> fileMetadata = new HashMap<String, FileMetadata>();
    private final Map<String, Boolean> byteSizeVerificationCache = new HashMap<String, Boolean>();
    private long lastByteSizeVerificationTime = 0L;
    private static final long BYTE_SIZE_VERIFICATION_COOLDOWN = 5000L;
    private boolean skipInitialScan = false;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderpacksWatcher] " + message);
    }

    public ShaderpacksWatcher(EuphoriaPatcher patcher) throws IOException {
        this(patcher, false);
    }

    public ShaderpacksWatcher(EuphoriaPatcher patcher, boolean skipInitialScan) throws IOException {
        ShaderpacksWatcher.debugLog("Initializing ShaderpacksWatcher" + (skipInitialScan ? " (skipping initial scan)" : ""));
        this.patcher = patcher;
        this.shaderpacks = EuphoriaPatcher.shaderpacks;
        this.watchService = FileSystems.getDefault().newWatchService();
        this.skipInitialScan = skipInitialScan;
        this.executor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "EuphoriaPatches-FileWatcher");
            thread.setDaemon(true);
            return thread;
        });
        ShaderpacksWatcher.debugLog("Registering watch events for directory: " + this.shaderpacks);
        this.shaderpacks.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW);
        if (!skipInitialScan) {
            ShaderpacksWatcher.debugLog("Performing initial directory scan");
            this.initialScan();
        } else {
            ShaderpacksWatcher.debugLog("Skipping initial scan as requested");
        }
    }

    private void initialScan() {
        ShaderpacksWatcher.debugLog("Starting initial scan of shaderpacks directory");
        int fileCount = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.shaderpacks);){
            for (Path path : stream) {
                String fileName = path.getFileName().toString();
                ShaderpacksWatcher.debugLog("Checking file: " + fileName);
                if (this.isPotentialShaderPack(path)) {
                    this.processedFiles.add(fileName);
                    ++fileCount;
                    ShaderpacksWatcher.debugLog("Added to processed files: " + fileName);
                    try {
                        BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                        this.fileMetadata.put(fileName, new FileMetadata(attrs.size(), attrs.lastModifiedTime().toMillis()));
                        ShaderpacksWatcher.debugLog("Saved file metadata for: " + fileName + " (size: " + attrs.size() + ", modified: " + attrs.lastModifiedTime().toMillis() + ")");
                    }
                    catch (IOException e) {
                        ShaderpacksWatcher.debugLog("Error reading file attributes for " + fileName + ": " + e.getMessage());
                        EuphoriaPatcher.log(2, 0, "Error reading file attributes: " + e.getMessage());
                    }
                    continue;
                }
                ShaderpacksWatcher.debugLog("Not a potential shader pack: " + fileName);
            }
            ShaderpacksWatcher.debugLog("Initial scan complete. Found " + fileCount + " potential shader packs");
        }
        catch (IOException e) {
            ShaderpacksWatcher.debugLog("Error during initial directory scan: " + e.getMessage());
            EuphoriaPatcher.log(2, 0, "Error during initial directory scan: " + e.getMessage());
        }
    }

    public void startWatching() {
        if (this.isRunning) {
            ShaderpacksWatcher.debugLog("Watcher already running, ignoring start request");
            return;
        }
        ShaderpacksWatcher.debugLog("Starting to watch shaderpacks folder");
        this.isRunning = true;
        EuphoriaPatcher.log(0, "Watching shaderpacks folder for ComplementaryShaders_r5.6.1...");
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                ShaderpacksWatcher.debugLog("Polling for file system events");
                WatchKey key = this.watchService.poll();
                if (key != null) {
                    ShaderpacksWatcher.debugLog("Processing watch events");
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        WatchEvent<?> ev = event;
                        Path fileName = (Path)ev.context();
                        String fileNameStr = fileName.toString();
                        ShaderpacksWatcher.debugLog("Event: " + kind.name() + " for file: " + fileNameStr);
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            ShaderpacksWatcher.debugLog("OVERFLOW detected, performing full directory rescan");
                            EuphoriaPatcher.log(0, "Detected filesystem overflow, rescanning directory");
                            this.scanDirectory();
                            continue;
                        }
                        if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                            ShaderpacksWatcher.debugLog("DELETE event: removing " + fileNameStr + " from tracking");
                            this.processedFiles.remove(fileNameStr);
                            this.invalidByteSizeFiles.remove(fileNameStr);
                            this.fileMetadata.remove(fileNameStr);
                            this.byteSizeVerificationCache.remove(fileNameStr);
                            continue;
                        }
                        if (kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                        Path fullPath = this.shaderpacks.resolve(fileName);
                        ShaderpacksWatcher.debugLog((kind == StandardWatchEventKinds.ENTRY_CREATE ? "CREATE" : "MODIFY") + " event: Processing " + fileNameStr);
                        try {
                            ShaderpacksWatcher.debugLog("Waiting for file system to settle");
                            Thread.sleep(1000L);
                            if (!this.isRunning) {
                                ShaderpacksWatcher.debugLog("Watcher stopped during event processing");
                                return;
                            }
                            if (!Files.exists(fullPath, new LinkOption[0])) {
                                ShaderpacksWatcher.debugLog("File no longer exists: " + fileNameStr);
                                continue;
                            }
                            if (!this.isPotentialShaderPack(fullPath)) {
                                ShaderpacksWatcher.debugLog("Not a potential shader pack: " + fileNameStr);
                                continue;
                            }
                            boolean shouldProcess = false;
                            try {
                                ShaderpacksWatcher.debugLog("Reading file attributes: " + fileNameStr);
                                BasicFileAttributes attrs = Files.readAttributes(fullPath, BasicFileAttributes.class, new LinkOption[0]);
                                FileMetadata newMetadata = new FileMetadata(attrs.size(), attrs.lastModifiedTime().toMillis());
                                FileMetadata oldMetadata = this.fileMetadata.get(fileNameStr);
                                boolean isNewFile = !this.processedFiles.contains(fileNameStr);
                                boolean isInvalidByteSize = this.invalidByteSizeFiles.contains(fileNameStr);
                                boolean hasChanged = oldMetadata != null && oldMetadata.hasChanged(newMetadata);
                                ShaderpacksWatcher.debugLog("File status - new: " + isNewFile + ", invalid bytesize: " + isInvalidByteSize + ", changed: " + hasChanged);
                                shouldProcess = isNewFile || isInvalidByteSize || hasChanged;
                                this.fileMetadata.put(fileNameStr, newMetadata);
                                ShaderpacksWatcher.debugLog("Updated file metadata for: " + fileNameStr);
                                if (shouldProcess) {
                                    if (isNewFile) {
                                        ShaderpacksWatcher.debugLog("Processing new shader pack: " + fileNameStr);
                                        EuphoriaPatcher.log(0, "Detected new shader pack: " + fileNameStr);
                                    } else if (hasChanged) {
                                        ShaderpacksWatcher.debugLog("Processing changed shader pack: " + fileNameStr);
                                        EuphoriaPatcher.log(0, "Detected changed shader pack: " + fileNameStr);
                                    } else if (isInvalidByteSize) {
                                        ShaderpacksWatcher.debugLog("Re-checking previously invalid shader pack: " + fileNameStr);
                                        EuphoriaPatcher.log(0, "Re-checking previously invalid shader pack: " + fileNameStr);
                                    }
                                    ShaderpacksWatcher.debugLog("Starting shader pack processing for: " + fileNameStr);
                                    boolean wasSuccessful = this.patcher.processNewShaderpack(fullPath);
                                    ShaderpacksWatcher.debugLog("Shader pack processing " + (wasSuccessful ? "successful" : "failed") + " for: " + fileNameStr);
                                    if (wasSuccessful) {
                                        this.processedFiles.add(fileNameStr);
                                        this.invalidByteSizeFiles.remove(fileNameStr);
                                        ShaderpacksWatcher.debugLog("Added to processed files: " + fileNameStr);
                                        continue;
                                    }
                                    this.invalidByteSizeFiles.add(fileNameStr);
                                    ShaderpacksWatcher.debugLog("Added to invalid byte size files: " + fileNameStr);
                                    continue;
                                }
                                ShaderpacksWatcher.debugLog("Skipping already processed file: " + fileNameStr);
                            }
                            catch (IOException e) {
                                ShaderpacksWatcher.debugLog("Error reading file attributes: " + e.getMessage());
                                EuphoriaPatcher.log(2, 0, "Error reading file attributes: " + e.getMessage());
                            }
                        }
                        catch (InterruptedException ie) {
                            ShaderpacksWatcher.debugLog("Thread interrupted, likely during shutdown");
                            Thread.currentThread().interrupt();
                            return;
                        }
                        catch (Exception e) {
                            ShaderpacksWatcher.debugLog("Error in shader pack watcher: " + e.getMessage());
                            EuphoriaPatcher.log(3, 0, "Error in shader pack watcher: " + e.getMessage());
                        }
                    }
                    key.reset();
                    ShaderpacksWatcher.debugLog("Watch key reset, waiting for next events");
                } else {
                    ShaderpacksWatcher.debugLog("No events to process");
                }
            }
            catch (Exception e) {
                ShaderpacksWatcher.debugLog("Error in shader pack watcher main loop: " + e.getMessage());
                EuphoriaPatcher.log(3, 0, "Error in shader pack watcher: " + e.getMessage());
            }
        }, 0L, 2L, TimeUnit.SECONDS);
        ShaderpacksWatcher.debugLog("Watcher scheduled and running");
    }

    private void scanDirectory() {
        ShaderpacksWatcher.debugLog("Starting full directory scan");
        int scannedCount = 0;
        int processedCount = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.shaderpacks);){
            for (Path path : stream) {
                String fileName = path.getFileName().toString();
                ++scannedCount;
                ShaderpacksWatcher.debugLog("Scanning file: " + fileName);
                if (!this.isPotentialShaderPack(path)) {
                    ShaderpacksWatcher.debugLog("Not a potential shader pack: " + fileName);
                    continue;
                }
                try {
                    BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    FileMetadata newMetadata = new FileMetadata(attrs.size(), attrs.lastModifiedTime().toMillis());
                    FileMetadata oldMetadata = this.fileMetadata.get(fileName);
                    boolean isNewFile = !this.processedFiles.contains(fileName);
                    boolean isInvalidByteSize = this.invalidByteSizeFiles.contains(fileName);
                    boolean hasChanged = oldMetadata != null && oldMetadata.hasChanged(newMetadata);
                    ShaderpacksWatcher.debugLog("File status - new: " + isNewFile + ", invalid bytesize: " + isInvalidByteSize + ", changed: " + hasChanged);
                    boolean shouldProcess = isNewFile || isInvalidByteSize || hasChanged;
                    this.fileMetadata.put(fileName, newMetadata);
                    ShaderpacksWatcher.debugLog("Updated file metadata for: " + fileName);
                    if (shouldProcess) {
                        if (isNewFile) {
                            ShaderpacksWatcher.debugLog("Processing new shader pack: " + fileName);
                            EuphoriaPatcher.log(0, "Found new shader pack during scan: " + fileName);
                        } else if (hasChanged) {
                            ShaderpacksWatcher.debugLog("Processing changed shader pack: " + fileName);
                            EuphoriaPatcher.log(0, "Found changed shader pack during scan: " + fileName);
                        } else if (isInvalidByteSize) {
                            ShaderpacksWatcher.debugLog("Re-checking previously invalid shader pack: " + fileName);
                            EuphoriaPatcher.log(0, "Re-checking previously invalid shader pack during scan: " + fileName);
                        }
                        ShaderpacksWatcher.debugLog("Starting shader pack processing for: " + fileName);
                        boolean wasSuccessful = this.patcher.processNewShaderpack(path);
                        ShaderpacksWatcher.debugLog("Shader pack processing " + (wasSuccessful ? "successful" : "failed") + " for: " + fileName);
                        ++processedCount;
                        if (wasSuccessful) {
                            this.processedFiles.add(fileName);
                            this.invalidByteSizeFiles.remove(fileName);
                            ShaderpacksWatcher.debugLog("Added to processed files: " + fileName);
                            continue;
                        }
                        this.invalidByteSizeFiles.add(fileName);
                        ShaderpacksWatcher.debugLog("Added to invalid byte size files: " + fileName);
                        continue;
                    }
                    ShaderpacksWatcher.debugLog("Skipping already processed file: " + fileName);
                }
                catch (IOException e) {
                    ShaderpacksWatcher.debugLog("Error reading file attributes during scan for " + fileName + ": " + e.getMessage());
                    EuphoriaPatcher.log(2, 0, "Error reading file attributes during scan: " + e.getMessage());
                }
            }
            ShaderpacksWatcher.debugLog("Directory scan complete. Scanned: " + scannedCount + " files, Processed: " + processedCount + " files");
        }
        catch (IOException e) {
            ShaderpacksWatcher.debugLog("Error scanning directory: " + e.getMessage());
            EuphoriaPatcher.log(2, 0, "Error scanning directory: " + e.getMessage());
        }
    }

    public void stopWatching() {
        if (!this.isRunning) {
            ShaderpacksWatcher.debugLog("Watcher not running, ignoring stop request");
            return;
        }
        ShaderpacksWatcher.debugLog("Stopping shader packs watcher");
        this.isRunning = false;
        EuphoriaPatcher.log(0, "Stopping shaderpacks folder watcher");
        this.executor.shutdownNow();
        ShaderpacksWatcher.debugLog("Executor service shutdown requested");
        try {
            this.watchService.close();
            ShaderpacksWatcher.debugLog("Watch service closed");
        }
        catch (IOException e) {
            ShaderpacksWatcher.debugLog("Error closing watch service: " + e.getMessage());
            EuphoriaPatcher.log(3, "Error closing watch service: " + e.getMessage());
        }
    }

    public void resetProcessedFiles() {
        ShaderpacksWatcher.debugLog("Resetting processed files tracking");
        this.processedFiles.clear();
        this.invalidByteSizeFiles.clear();
        this.fileMetadata.clear();
        EuphoriaPatcher.log(0, "Resetting file watcher to detect replacements");
        ShaderpacksWatcher.debugLog("File tracking reset complete");
    }

    public void resetAfterByeSizeFailure() {
        ShaderpacksWatcher.debugLog("Resetting after byte size failure");
        this.processedFiles.clear();
        this.fileMetadata.clear();
        ShaderpacksWatcher.debugLog("Processed files and metadata cleared, invalid byte size tracking maintained");
        if (!this.isRunning) {
            ShaderpacksWatcher.debugLog("Watcher stopped, attempting to restart");
            try {
                this.startWatching();
                ShaderpacksWatcher.debugLog("Watcher successfully restarted");
            }
            catch (Exception e) {
                ShaderpacksWatcher.debugLog("Failed to restart watcher: " + e.getMessage());
                EuphoriaPatcher.log(3, 0, "Failed to restart watcher after byte size failure: " + e.getMessage());
            }
        }
    }

    public void trackInvalidByteSizeFile(String fileName) {
        if (fileName != null && !fileName.isEmpty()) {
            ShaderpacksWatcher.debugLog("Tracking invalid byte size file: " + fileName);
            this.invalidByteSizeFiles.add(fileName);
        } else {
            ShaderpacksWatcher.debugLog("Attempted to track null or empty filename as invalid");
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public static ShaderpacksWatcher createAndStart(EuphoriaPatcher patcher) {
        return ShaderpacksWatcher.createAndStart(patcher, false);
    }

    public static ShaderpacksWatcher createAndStart(EuphoriaPatcher patcher, boolean skipInitialScan) {
        ShaderpacksWatcher.debugLog("Creating and starting new ShaderpacksWatcher" + (skipInitialScan ? " (skipping initial scan)" : ""));
        try {
            ShaderpacksWatcher watcher = new ShaderpacksWatcher(patcher, skipInitialScan);
            watcher.startWatching();
            ShaderpacksWatcher.debugLog("ShaderpacksWatcher successfully created and started");
            return watcher;
        }
        catch (IOException e) {
            ShaderpacksWatcher.debugLog("Failed to create shaderpacks watcher: " + e.getMessage());
            EuphoriaPatcher.log(3, 0, "Failed to create shaderpacks watcher: " + e.getMessage());
            return null;
        }
    }

    private boolean isPotentialShaderPack(Path path) {
        String fileName = path.getFileName().toString();
        if (fileName.contains("_0EuphoriaPatches_ErrorShader")) {
            ShaderpacksWatcher.debugLog("Skipping error shader from processing: " + fileName);
            return false;
        }
        try {
            boolean nameMatches;
            ShaderpacksWatcher.debugLog("Evaluating potential shader pack: " + fileName);
            boolean bl = nameMatches = fileName.matches("Complementary.*_r5.6.1.*") && !fileName.contains("EuphoriaPatches");
            if (nameMatches) {
                ShaderpacksWatcher.debugLog("File name matches shader pack pattern: " + fileName);
                if (fileName.endsWith(".zip")) {
                    boolean validZip = Files.exists(path, new LinkOption[0]) && Files.size(path) > 0L;
                    ShaderpacksWatcher.debugLog("ZIP file validation: " + (validZip ? "valid" : "invalid") + " - " + fileName);
                    return validZip;
                }
                boolean isDir = Files.isDirectory(path, new LinkOption[0]);
                ShaderpacksWatcher.debugLog("Directory validation: " + (isDir ? "valid" : "invalid") + " - " + fileName);
                return isDir;
            }
            if (this.byteSizeVerificationCache.containsKey(fileName)) {
                boolean cached = this.byteSizeVerificationCache.get(fileName);
                ShaderpacksWatcher.debugLog("Using cached verification result for " + fileName + ": " + cached);
                return cached;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastByteSizeVerificationTime < 5000L) {
                ShaderpacksWatcher.debugLog("Skipping byte size verification due to cooldown: " + fileName);
                return false;
            }
            this.lastByteSizeVerificationTime = currentTime;
            ShaderpacksWatcher.debugLog("Updated verification time, proceeding with byte size check: " + fileName);
            if (fileName.endsWith(".zip") && Files.exists(path, new LinkOption[0]) && Files.size(path) > 100000L || Files.isDirectory(path, new LinkOption[0])) {
                ShaderpacksWatcher.debugLog("Starting byte size verification for: " + fileName);
                EuphoriaPatcher.log(0, "Checking if file matches by byte size (watcher): " + fileName);
                boolean isValidByByteSize = false;
                if (this.patcher != null) {
                    isValidByByteSize = this.patcher.isValidShaderByByteSize(path);
                    ShaderpacksWatcher.debugLog("Byte size verification result: " + (isValidByByteSize ? "valid" : "invalid") + " - " + fileName);
                    if (isValidByByteSize) {
                        EuphoriaPatcher.log(0, "File passed byte size verification: " + fileName);
                    } else {
                        EuphoriaPatcher.log(3, "The " + fileName + " shaderpack which just got added did not pass the byte size verification for ComplementaryShaders_r5.6.1. It may be an incorrect version or modified.");
                        EuphoriaPatcher.log(3, "Please download the correct and official version from https://www.complementary.dev/");
                    }
                    if (isValidByByteSize) {
                        ShaderpacksWatcher.debugLog("Found valid shader by byte size, renaming: " + fileName);
                        EuphoriaPatcher.log(0, "Found valid shader by byte size in watcher: " + fileName);
                        Path renamedPath = this.patcher.renameToCorrectShaderName(path);
                        String newFileName = renamedPath.getFileName().toString();
                        ShaderpacksWatcher.debugLog("Renamed from " + fileName + " to " + newFileName);
                        this.byteSizeVerificationCache.put(fileName, true);
                        ShaderpacksWatcher.debugLog("Added to byte size cache: " + fileName);
                        if (!fileName.equals(newFileName)) {
                            this.byteSizeVerificationCache.put(newFileName, true);
                            ShaderpacksWatcher.debugLog("Added new name to byte size cache: " + newFileName);
                            this.processedFiles.remove(fileName);
                            this.invalidByteSizeFiles.remove(fileName);
                            this.fileMetadata.remove(fileName);
                            ShaderpacksWatcher.debugLog("Updated tracking for renamed file");
                        }
                    }
                } else {
                    ShaderpacksWatcher.debugLog("Patcher is null, cannot verify by byte size: " + fileName);
                }
                this.byteSizeVerificationCache.put(fileName, isValidByByteSize);
                ShaderpacksWatcher.debugLog("Cached byte size verification result: " + fileName + " = " + isValidByByteSize);
                return isValidByByteSize;
            }
            ShaderpacksWatcher.debugLog("File too small or invalid for byte size verification: " + fileName);
            ShaderpacksWatcher.debugLog("File is not a potential shader pack: " + fileName);
            return false;
        }
        catch (IOException e) {
            ShaderpacksWatcher.debugLog("Error checking shader pack name: " + fileName + " - " + e.getMessage());
            EuphoriaPatcher.log(2, 0, "Error checking shader pack name: " + e.getMessage());
            return false;
        }
    }

    private static class FileMetadata {
        final long size;
        final long lastModified;

        FileMetadata(long size, long lastModified) {
            this.size = size;
            this.lastModified = lastModified;
        }

        boolean hasChanged(FileMetadata other) {
            return this.size != other.size || this.lastModified != other.lastModified;
        }
    }
}

