/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.util.type_adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dmr.DragonMounts.DMR;
import java.lang.reflect.Type;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class SoundEventAdapter
implements JsonDeserializer<SoundEvent>,
JsonSerializer<SoundEvent> {
    public SoundEvent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            try {
                ResourceLocation location = ResourceLocation.parse((String)json.getAsString());
                return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(location);
            }
            catch (Exception e) {
                DMR.LOGGER.warn("Failed to deserialize SoundEvent: {}", (Object)json);
            }
        }
        try {
            SoundEvent sound;
            Holder event = SoundEvent.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(System.err::println).orElse(null);
            if (event != null && (sound = (SoundEvent)event.unwrap().right().orElse(null)) != null) {
                return sound;
            }
        }
        catch (Exception e) {
            DMR.LOGGER.warn("Failed to deserialize SoundEvent: {}", (Object)json);
        }
        return null;
    }

    public JsonElement serialize(SoundEvent src, Type typeOfSrc, JsonSerializationContext context) {
        return (JsonElement)SoundEvent.CODEC.encode((Object)Holder.direct((Object)src), (DynamicOps)JsonOps.INSTANCE, null).getOrThrow();
    }
}

