/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.util;

import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.server.entity.TameableDragonEntity;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.types.habitats.Habitat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BreedingUtils {
    static final ExecutorService executor = Executors.newSingleThreadExecutor();

    public static IDragonBreed getHabitatBreedOutcome(ServerLevel level, BlockPos pos) {
        List<Map.Entry<Integer, IDragonBreed>> outcomes = BreedingUtils.getHabitatBreedOutcomes(level, pos);
        Optional first = outcomes.stream().findFirst();
        return first.map(Map.Entry::getValue).orElse(null);
    }

    public static List<Map.Entry<Integer, IDragonBreed>> getHabitatBreedOutcomes(ServerLevel level, BlockPos pos) {
        ArrayList<Map.Entry<Integer, IDragonBreed>> outcomes = new ArrayList<Map.Entry<Integer, IDragonBreed>>();
        for (IDragonBreed dragonBreed : DragonBreedsRegistry.getDragonBreeds()) {
            if (dragonBreed.isHybrid() || dragonBreed.getHabitats() == null || dragonBreed.getHabitats().isEmpty()) continue;
            int points = 0;
            for (Habitat habitat : dragonBreed.getHabitats()) {
                if (habitat == null) continue;
                points += Math.max(0, habitat.getHabitatPoints((Level)level, pos));
            }
            if (points <= 0) continue;
            outcomes.add(new AbstractMap.SimpleEntry<Integer, IDragonBreed>(points, dragonBreed));
        }
        outcomes.sort(Comparator.comparingInt(Map.Entry::getKey));
        Collections.reverse(outcomes);
        return outcomes;
    }

    @NotNull
    public static String generateCustomName(TameableDragonEntity mate1, Animal animal) {
        String babyName;
        String p1Name = mate1.getCustomName().getString();
        String p2Name = animal.getCustomName().getString();
        if (p1Name.contains(" ") || p2Name.contains(" ")) {
            String[] p1Names = p1Name.split(" ");
            String[] p2Names = p2Name.split(" ");
            p1Name = StringUtils.capitalize((String)p1Names[mate1.getRandom().nextInt(p1Names.length)]);
            p2Name = StringUtils.capitalize((String)p2Names[mate1.getRandom().nextInt(p2Names.length)]);
            babyName = mate1.getRandom().nextBoolean() ? p1Name + " " + p2Name : p2Name + " " + p1Name;
        } else {
            p1Name = mate1.getRandom().nextBoolean() ? p1Name.substring(0, (p1Name.length() - 1) / 2) : p1Name.substring((p1Name.length() - 1) / 2);
            p2Name = mate1.getRandom().nextBoolean() ? p2Name.substring(0, (p2Name.length() - 1) / 2) : p2Name.substring((p2Name.length() - 1) / 2);
            p2Name = StringUtils.capitalize((String)p2Name);
            babyName = mate1.getRandom().nextBoolean() ? p1Name + p2Name : p2Name + p1Name;
        }
        return babyName;
    }
}

