/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types.dragonBreeds;

import com.google.gson.annotations.SerializedName;
import dmr.DragonMounts.types.abilities.types.Ability;
import dmr.DragonMounts.types.breath.DragonBreathType;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import dmr.DragonMounts.types.habitats.Habitat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;

public class DragonHybridBreed
implements IDragonBreed {
    @SerializedName(value="parent1")
    public IDragonBreed parent1;
    @SerializedName(value="parent1")
    public IDragonBreed parent2;

    public DragonHybridBreed(IDragonBreed parent1, IDragonBreed parent2) {
        this.parent1 = parent1;
        this.parent2 = parent2;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"dragon_breed.hybrid", (Object[])new Object[]{this.parent1.getName().getString(), this.parent2.getName().getString()});
    }

    @Override
    public ResourceLocation getInventoryTexture() {
        return this.parent1.getInventoryTexture();
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.parent1.getResourceLocation() != null ? this.parent1.getResourceLocation() : this.parent2.getResourceLocation();
    }

    @Override
    public ResourceLocation getDragonModelLocation() {
        return this.parent1.getDragonModelLocation() != null ? this.parent1.getDragonModelLocation() : this.parent2.getDragonModelLocation();
    }

    @Override
    public ResourceLocation getDragonAnimationLocation() {
        return this.parent1.getDragonAnimationLocation() != null ? this.parent1.getDragonAnimationLocation() : this.parent2.getDragonAnimationLocation();
    }

    @Override
    public String getArmorTypeId() {
        return this.parent1.getArmorTypeId() != null ? this.parent1.getArmorTypeId() : this.parent2.getArmorTypeId();
    }

    @Override
    public int getPrimaryColor() {
        return this.parent1.getPrimaryColor();
    }

    @Override
    public int getSecondaryColor() {
        return this.parent2.getPrimaryColor();
    }

    @Override
    public DragonBreathType getBreathType() {
        return this.parent1.getBreathType() != null ? this.parent1.getBreathType() : (this.parent2.getBreathType() != null ? this.parent2.getBreathType() : null);
    }

    @Override
    public String getId() {
        return "hybrid_" + this.parent1.getId() + "_" + this.parent2.getId();
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public ResourceLocation getDeathLootTable() {
        return this.parent1.getDeathLootTable() != null ? this.parent1.getDeathLootTable() : this.parent2.getDeathLootTable();
    }

    @Override
    public SoundEvent getAmbientSound() {
        return this.parent1.getAmbientSound() != null ? this.parent1.getAmbientSound() : this.parent2.getAmbientSound();
    }

    @Override
    public int getHatchTime() {
        return (this.parent1.getHatchTime() + this.parent2.getHatchTime()) / 2;
    }

    @Override
    public int getGrowthTime() {
        return (this.parent1.getGrowthTime() + this.parent2.getGrowthTime()) / 2;
    }

    @Override
    public float getSizeModifier() {
        return (this.parent1.getSizeModifier() + this.parent2.getSizeModifier()) / 2.0f;
    }

    @Override
    public List<String> getImmunities() {
        ArrayList<String> immunities = new ArrayList<String>();
        if (this.parent1.getImmunities() != null) {
            if (this.parent1.getImmunities().size() > 1) {
                immunities.addAll(this.parent1.getImmunities().subList(0, this.parent1.getImmunities().size() / 2));
            } else {
                immunities.addAll(this.parent1.getImmunities());
            }
        }
        if (this.parent2.getImmunities() != null) {
            if (this.parent2.getImmunities().size() > 1) {
                immunities.addAll(this.parent2.getImmunities().subList(this.parent2.getImmunities().size() / 2, this.parent2.getImmunities().size()));
            } else {
                immunities.addAll(this.parent2.getImmunities());
            }
        }
        return immunities;
    }

    @Override
    public Map<ResourceLocation, Double> getAttributes() {
        HashMap<ResourceLocation, Double> attributes = new HashMap<ResourceLocation, Double>();
        if (this.parent1.getAttributes() != null) {
            attributes.putAll(this.parent1.getAttributes());
        }
        if (this.parent2.getAttributes() != null) {
            attributes.putAll(this.parent2.getAttributes());
        }
        return attributes;
    }

    @Override
    public List<Habitat> getHabitats() {
        return List.of();
    }

    @Override
    public List<Ability> getAbilities() {
        ArrayList<Ability> abilities = new ArrayList<Ability>();
        if (this.parent1.getAbilities() != null) {
            if (this.parent1.getAbilities().size() > 1) {
                abilities.addAll(this.parent1.getAbilities().subList(0, this.parent1.getAbilities().size() / 2));
            } else {
                abilities.addAll(this.parent1.getAbilities());
            }
        }
        if (this.parent2.getAbilities() != null) {
            if (this.parent2.getAbilities().size() > 1) {
                abilities.addAll(this.parent2.getAbilities().subList(this.parent2.getAbilities().size() / 2, this.parent2.getAbilities().size()));
            } else {
                abilities.addAll(this.parent2.getAbilities());
            }
        }
        return abilities;
    }

    @Override
    public List<Item> getTamingItems() {
        ArrayList<Item> tamingItems = new ArrayList<Item>();
        if (this.parent1.getTamingItems() != null) {
            tamingItems.addAll(this.parent1.getTamingItems());
        }
        if (this.parent2.getTamingItems() != null) {
            tamingItems.addAll(this.parent2.getTamingItems());
        }
        return tamingItems;
    }

    @Override
    public List<Item> getBreedingItems() {
        ArrayList<Item> breedingItems = new ArrayList<Item>();
        if (this.parent1.getBreedingItems() != null) {
            breedingItems.addAll(this.parent1.getBreedingItems());
        }
        if (this.parent2.getBreedingItems() != null) {
            breedingItems.addAll(this.parent2.getBreedingItems());
        }
        return breedingItems;
    }

    @Override
    public ParticleOptions getHatchParticles() {
        return this.parent2.getHatchParticles() != null ? this.parent2.getHatchParticles() : this.parent1.getHatchParticles();
    }

    @Override
    public List<String> getAccessories() {
        ArrayList<String> modelProperties = new ArrayList<String>();
        if (this.parent1.getAccessories() != null) {
            if (this.parent1.getAccessories().size() > 1) {
                modelProperties.addAll(this.parent1.getAccessories().subList(0, this.parent1.getAccessories().size() / 2));
            } else {
                modelProperties.addAll(this.parent1.getAccessories());
            }
        }
        if (this.parent2.getAccessories() != null) {
            if (this.parent2.getAccessories().size() > 1) {
                modelProperties.addAll(this.parent2.getAccessories().subList(this.parent2.getAccessories().size() / 2, this.parent2.getAccessories().size()));
            } else {
                modelProperties.addAll(this.parent2.getAccessories());
            }
        }
        return modelProperties;
    }

    @Override
    public List<IDragonBreed.LootTableEntry> getLootTable() {
        ArrayList<IDragonBreed.LootTableEntry> list = new ArrayList<IDragonBreed.LootTableEntry>();
        if (this.parent1.getLootTable() != null) {
            list.addAll(this.parent1.getLootTable().subList(0, this.parent1.getLootTable().size() / 2));
        }
        if (this.parent2.getLootTable() != null) {
            list.addAll(this.parent2.getLootTable().subList(this.parent2.getLootTable().size() / 2, this.parent2.getLootTable().size()));
        }
        return list;
    }

    public String toString() {
        return "DragonHybridBreed{parent1=" + String.valueOf(this.parent1) + ", parent2=" + String.valueOf(this.parent2) + "}";
    }

    @Override
    public List<IDragonBreed.Variant> getVariants() {
        return List.of();
    }
}

