/*
 * Decompiled with CFR 0.152.
 */
package dmr.DragonMounts.types;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import dmr.DragonMounts.DMR;
import dmr.DragonMounts.config.ServerConfig;
import dmr.DragonMounts.network.packets.SyncDataPackPacket;
import dmr.DragonMounts.registry.DragonArmorRegistry;
import dmr.DragonMounts.registry.DragonBreathRegistry;
import dmr.DragonMounts.registry.DragonBreedsRegistry;
import dmr.DragonMounts.registry.ModAdvancements;
import dmr.DragonMounts.server.events.LootTableInject;
import dmr.DragonMounts.types.armor.DragonArmor;
import dmr.DragonMounts.types.breath.DragonBreathType;
import dmr.DragonMounts.types.dragonBreeds.DragonBreed;
import dmr.DragonMounts.types.dragonBreeds.IDragonBreed;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

public class DataPackHandler {
    public static final ResourceKey<Registry<DragonBreed>> BREEDS_KEY = ResourceKey.createRegistryKey((ResourceLocation)DMR.id("breeds"));
    public static final ResourceKey<Registry<DragonArmor>> ARMORS_KEY = ResourceKey.createRegistryKey((ResourceLocation)DMR.id("armor"));
    public static final ResourceKey<Registry<DragonBreathType>> BREATH_TYPES_KEY = ResourceKey.createRegistryKey((ResourceLocation)DMR.id("breath_types"));
    public static final Codec<DragonBreed> BREED_CODEC = new PrimitiveCodec<DragonBreed>(){

        public <T> DataResult<DragonBreed> read(DynamicOps<T> ops, T input) {
            return DataPackHandler.readData(input, DragonBreed.class);
        }

        public <T> T write(DynamicOps<T> ops, DragonBreed value) {
            return (T)ops.createString(DMR.getGson().toJson((Object)value));
        }
    };
    public static final Codec<DragonArmor> ARMOR_CODEC = new PrimitiveCodec<DragonArmor>(){

        public <T> DataResult<DragonArmor> read(DynamicOps<T> ops, T input) {
            return DataPackHandler.readData(input, DragonArmor.class);
        }

        public <T> T write(DynamicOps<T> ops, DragonArmor value) {
            return (T)ops.createString(DMR.getGson().toJson((Object)value));
        }
    };
    public static final Codec<DragonBreathType> BREATH_TYPE_CODEC = new PrimitiveCodec<DragonBreathType>(){

        public <T> DataResult<DragonBreathType> read(DynamicOps<T> ops, T input) {
            return DataPackHandler.readData(input, DragonBreathType.class);
        }

        public <T> T write(DynamicOps<T> ops, DragonBreathType value) {
            return (T)ops.createString(DMR.getGson().toJson((Object)value));
        }
    };

    public static void newDataPack(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(BREEDS_KEY, BREED_CODEC, BREED_CODEC);
        event.dataPackRegistry(ARMORS_KEY, ARMOR_CODEC, ARMOR_CODEC);
        event.dataPackRegistry(BREATH_TYPES_KEY, BREATH_TYPE_CODEC, BREATH_TYPE_CODEC);
    }

    public static void dataPackData(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            event.getPlayerList().getPlayers().stream().findFirst().ifPresent(player -> DataPackHandler.run((LevelAccessor)player.level));
            event.getPlayerList().getPlayers().forEach(player -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncDataPackPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]));
        } else {
            DataPackHandler.run((LevelAccessor)event.getPlayer().level);
            PacketDistributor.sendToPlayer((ServerPlayer)event.getPlayer(), (CustomPacketPayload)new SyncDataPackPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void run(LevelAccessor level) {
        ResourceKey key;
        Registry breed_reg = level.registryAccess().registry(BREEDS_KEY).orElseGet(() -> RegistryAccess.EMPTY.registryOrThrow(BREEDS_KEY));
        Registry armor_reg = level.registryAccess().registry(ARMORS_KEY).orElseGet(() -> RegistryAccess.EMPTY.registryOrThrow(ARMORS_KEY));
        Registry breath_reg = level.registryAccess().registry(BREATH_TYPES_KEY).orElseGet(() -> RegistryAccess.EMPTY.registryOrThrow(BREATH_TYPES_KEY));
        ArrayList<DragonArmor> armorList = new ArrayList<DragonArmor>();
        ArrayList<IDragonBreed> breedList = new ArrayList<IDragonBreed>();
        ArrayList<DragonBreathType> breathList = new ArrayList<DragonBreathType>();
        for (Map.Entry ent : armor_reg.entrySet()) {
            key = (ResourceKey)ent.getKey();
            DragonArmor armor = (DragonArmor)ent.getValue();
            armor.setId(key.location().getPath());
            armorList.add(armor);
        }
        DragonArmorRegistry.setArmors(armorList);
        for (Map.Entry ent : breath_reg.entrySet()) {
            key = (ResourceKey)ent.getKey();
            DragonBreathType breathType = (DragonBreathType)ent.getValue();
            breathType.setId(key.location().getPath());
            breathList.add(breathType);
        }
        DragonBreathRegistry.setBreathTypes(breathList);
        for (Map.Entry ent : breed_reg.entrySet()) {
            key = (ResourceKey)ent.getKey();
            DragonBreed breed = (DragonBreed)ent.getValue();
            breed.setId(key.location().getPath());
            breedList.add(breed);
        }
        DragonBreedsRegistry.setBreeds(breedList);
        DragonBreedsRegistry.registerHybrids();
        LootTableInject.firstLoadInjectArmor(level);
        LootTableInject.firstLoadInjectBreeds(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ModAdvancements.init(serverLevel);
        }
        if (!ServerConfig.ENABLE_BLANK_EGG) {
            MinecraftServer server = level.getServer();
            if (server == null) {
                return;
            }
            server.getRecipeManager().replaceRecipes(server.getRecipeManager().getRecipes().stream().filter(recipe -> !recipe.id().equals((Object)DMR.id("blank_egg"))).toList());
        }
    }

    private static <T> DataResult<T> readData(Object input, Class<T> clas) {
        if (input instanceof JsonElement) {
            JsonElement el = (JsonElement)input;
            try {
                return DataResult.success((Object)DMR.getGson().fromJson(el, clas));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (input instanceof StringTag) {
            StringTag tag = (StringTag)input;
            try {
                return DataResult.success((Object)DMR.getGson().fromJson(tag.getAsString(), clas));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return DataResult.error(() -> "Expected JsonElement, got " + input.getClass().getSimpleName());
    }
}

